/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.desc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.seasar.extension.jdbc.gen.desc.TableDesc;
import org.seasar.framework.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseDesc {
    protected boolean filtered;
    protected List<TableDesc> tableDescList = new ArrayList<TableDesc>();
    protected Map<String, TableDesc> tableDescMap = new CaseInsensitiveMap();

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public List<TableDesc> getTableDescList() {
        return Collections.unmodifiableList(this.tableDescList);
    }

    public void addTableDesc(TableDesc tableDesc) {
        if (!this.tableDescList.contains(tableDesc)) {
            this.tableDescList.add(tableDesc);
            this.tableDescMap.put(tableDesc.getCanonicalName(), tableDesc);
        }
    }

    public TableDesc getTableDesc(String canonicalTableName) {
        return this.tableDescMap.get(canonicalTableName);
    }
}

