/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.dialect;

import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.SelectForUpdateType;
import org.seasar.extension.jdbc.dialect.StandardDialect;

public class HsqlDialect
extends StandardDialect {
    protected static final int uniqueConstraintViolationCode = -104;

    public String getName() {
        return "hsql";
    }

    public boolean supportsLimit() {
        return true;
    }

    public String convertLimitSql(String sql, int offset, int limit) {
        StringBuilder buf = new StringBuilder(sql.length() + 20);
        buf.append(sql);
        if (offset > 0) {
            buf.append(" limit ");
            buf.append(limit);
            buf.append(" offset ");
            buf.append(offset);
        } else {
            buf.append(" limit ");
            buf.append(limit);
        }
        return buf.toString();
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean isInsertIdentityColumn() {
        return true;
    }

    public String getIdentitySelectString(String tableName, String columnName) {
        return "call identity()";
    }

    public boolean supportsSequence() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return "SELECT NEXT VALUE FOR " + sequenceName + " FROM INFORMATION_SCHEMA.SYSTEM_TABLES WHERE table_name = 'SYSTEM_TABLES'";
    }

    public boolean supportsForUpdate(SelectForUpdateType type, boolean withTarget) {
        return false;
    }

    public boolean isUniqueConstraintViolation(Throwable t) {
        Integer code = this.getErrorCode(t);
        if (code != null) {
            return -104 == code;
        }
        return false;
    }
}

