/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueDecimal
extends Value {
    private final BigDecimal value;
    private String valueString;
    private int precision;
    private static final BigDecimal DEC_ZERO = new BigDecimal("0");
    private static final BigDecimal DEC_ONE = new BigDecimal("1");
    private static final ValueDecimal ZERO = new ValueDecimal(DEC_ZERO);
    private static final ValueDecimal ONE = new ValueDecimal(DEC_ONE);
    public static final int DEFAULT_PRECISION = 65535;
    public static final int DEFAULT_SCALE = Short.MAX_VALUE;
    private static final int DIVIDE_SCALE_ADD = 25;

    private ValueDecimal(BigDecimal value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (!SysProperties.ALLOW_BIG_DECIMAL_EXTENSIONS && !value.getClass().equals(BigDecimal.class)) {
            JdbcSQLException e = Message.getSQLException(90125, new String[]{BigDecimal.class.getName(), value.getClass().getName()});
            throw Message.convertToInternal(e);
        }
        this.value = value;
    }

    public Value add(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        return ValueDecimal.get(this.value.add(dec.value));
    }

    public Value subtract(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        return ValueDecimal.get(this.value.subtract(dec.value));
    }

    public Value negate() {
        return ValueDecimal.get(this.value.negate());
    }

    public Value multiply(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        return ValueDecimal.get(this.value.multiply(dec.value));
    }

    public Value divide(Value v) throws SQLException {
        ValueDecimal dec = (ValueDecimal)v;
        if (dec.value.signum() == 0) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        BigDecimal bd = this.value.divide(dec.value, this.value.scale() + 25, 5);
        if (bd.signum() == 0) {
            bd = DEC_ZERO;
        } else if (bd.scale() > 0 && !bd.unscaledValue().testBit(0)) {
            int i;
            String s = bd.toString();
            for (i = s.length() - 1; i >= 0 && s.charAt(i) == '0'; --i) {
            }
            if (i < s.length() - 1) {
                s = s.substring(0, i + 1);
                bd = new BigDecimal(s);
            }
        }
        return ValueDecimal.get(bd);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 6;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueDecimal v = (ValueDecimal)o;
        int c = this.value.compareTo(v.value);
        return c == 0 ? 0 : (c < 0 ? -1 : 1);
    }

    public int getSignum() {
        return this.value.signum();
    }

    public BigDecimal getBigDecimal() {
        return this.value;
    }

    public String getString() {
        if (this.valueString == null) {
            this.valueString = this.value.toString();
        }
        return this.valueString;
    }

    public long getPrecision() {
        if (this.precision == 0) {
            this.precision = this.value.unscaledValue().abs().toString().length();
        }
        return this.precision;
    }

    public boolean checkPrecision(long precision) {
        if (precision == 65535L) {
            return true;
        }
        return this.getPrecision() <= precision;
    }

    public int getScale() {
        return this.value.scale();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBigDecimal(parameterIndex, this.value);
    }

    public Value convertScale(boolean onlyToSmallerScale, int targetScale) throws SQLException {
        if (this.value.scale() == targetScale) {
            return this;
        }
        if ((onlyToSmallerScale || targetScale >= Short.MAX_VALUE) && this.value.scale() < targetScale) {
            return this;
        }
        BigDecimal bd = MathUtils.setScale(this.value, targetScale);
        return ValueDecimal.get(bd);
    }

    public Value convertPrecision(long precision) throws SQLException {
        if (this.getPrecision() <= precision) {
            return this;
        }
        throw Message.getSQLException(90039, "" + precision);
    }

    public static ValueDecimal get(BigDecimal dec) {
        if (DEC_ZERO.equals(dec)) {
            return ZERO;
        }
        if (DEC_ONE.equals(dec)) {
            return ONE;
        }
        return (ValueDecimal)Value.cache(new ValueDecimal(dec));
    }

    public int getDisplaySize() {
        return this.getString().length();
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueDecimal && this.value.equals(((ValueDecimal)v).value);
    }
}

