/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.bnf.Rule;
import org.h2.bnf.Sentence;

public class RuleList
implements Rule {
    private boolean or;
    private ArrayList list;
    private boolean mapSet;

    RuleList(ArrayList list, boolean or) {
        this.or = or;
        this.list = list;
    }

    RuleList(Rule first, Rule next, boolean or) {
        this.list = new ArrayList();
        if (first instanceof RuleList && ((RuleList)first).or == or) {
            this.list.addAll(((RuleList)first).list);
        } else {
            this.list.add(first);
        }
        if (next instanceof RuleList && ((RuleList)next).or == or) {
            this.list.addAll(((RuleList)next).list);
        } else {
            this.list.add(next);
        }
        if (!or) {
            // empty if block
        }
        this.or = or;
    }

    public String random(Bnf config, int level) {
        if (this.or) {
            if (level > 10) {
                if (level > 1000) {
                    throw new Error();
                }
                return this.get(0).random(config, level);
            }
            int idx = config.getRandom().nextInt(this.list.size());
            return this.get(idx).random(config, level + 1);
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.list.size(); ++i) {
            buff.append(this.get(i).random(config, level + 1));
        }
        return buff.toString();
    }

    private Rule get(int idx) {
        return (Rule)this.list.get(idx);
    }

    public String name() {
        return null;
    }

    public Rule last() {
        return this.get(this.list.size() - 1);
    }

    public void setLinks(HashMap ruleMap) {
        if (!this.mapSet) {
            for (int i = 0; i < this.list.size(); ++i) {
                this.get(i).setLinks(ruleMap);
            }
            this.mapSet = true;
        }
    }

    public String matchRemove(String query, Sentence sentence) {
        if (query.length() == 0) {
            return null;
        }
        if (this.or) {
            for (int i = 0; i < this.list.size(); ++i) {
                String s = this.get(i).matchRemove(query, sentence);
                if (s == null) continue;
                return s;
            }
            return null;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Rule r = this.get(i);
            query = r.matchRemove(query, sentence);
            if (query != null) continue;
            return null;
        }
        return query;
    }

    public void addNextTokenList(String query, Sentence sentence) {
        if (sentence.stop()) {
            // empty if block
        }
        if (this.or) {
            for (int i = 0; i < this.list.size(); ++i) {
                this.get(i).addNextTokenList(query, sentence);
            }
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                Rule r = this.get(i);
                r.addNextTokenList(query, sentence);
                query = r.matchRemove(query, sentence);
                if (query != null) {
                    continue;
                }
                break;
            }
        }
    }
}

