/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.util.StringUtil;

public class SQLVarbit
extends SQLBit {
    public String getTypeName() {
        return "VARCHAR () FOR BIT DATA";
    }

    int getMaxMemoryUsage() {
        return 32672;
    }

    public DataValueDescriptor getNewNull() {
        return new SQLVarbit();
    }

    public int getTypeFormatId() {
        return 88;
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = dataTypeDescriptor.getMaximumWidth();
        byte[] byArray = dataValueDescriptor.getBytes();
        this.setValue(byArray);
        if (byArray.length > n) {
            this.setWidth(n, 0, true);
        }
    }

    public void setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.getValue() == null) {
            return;
        }
        int n3 = this.dataValue.length;
        if (n3 > n) {
            if (bl) {
                for (int i = n; i < this.dataValue.length; ++i) {
                    if (this.dataValue[i] == 32) continue;
                    throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)StringUtil.formatForPrint(this.toString()), (Object)String.valueOf(n));
                }
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.dataValue, 0, byArray, 0, n);
            this.dataValue = byArray;
        }
    }

    public SQLVarbit() {
    }

    public SQLVarbit(byte[] byArray) {
        super(byArray);
    }

    public int typePrecedence() {
        return 150;
    }
}

