/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;

final class CachedItem {
    private boolean valid_ = false;
    private boolean removeRequested_ = false;
    private boolean settingIdentity_ = false;
    private boolean removeOk_ = false;
    private boolean recentlyUsed_ = false;
    private int keepCount;
    private Cacheable entry;

    public void keepAfterSearch() {
        ++this.keepCount;
        this.setUsed(true);
    }

    public void keepForCreate() {
        this.keepCount = 1;
        this.settingIdentity_ = true;
    }

    public void unkeepForCreate() {
        this.settingIdentityComplete();
        this.unkeep();
    }

    public void keepForClean() {
        ++this.keepCount;
    }

    public synchronized boolean unkeep() {
        boolean bl = --this.keepCount == 0;
        return bl && this.removeRequested_;
    }

    public final boolean isKept() {
        return this.keepCount != 0;
    }

    public void clean(boolean bl) throws StandardException {
        this.entry.clean(bl);
    }

    public synchronized void setRemoveState() {
        this.removeRequested_ = true;
    }

    public final synchronized boolean isValid() {
        return this.valid_;
    }

    public synchronized void setValidState(boolean bl) {
        this.valid_ = bl;
        this.removeRequested_ = false;
        this.removeOk_ = false;
        this.recentlyUsed_ = bl;
    }

    public Cacheable getEntry() {
        return this.entry;
    }

    public Cacheable takeOnIdentity(CacheManager cacheManager, CacheableFactory cacheableFactory, Object object, boolean bl, Object object2) throws StandardException {
        Cacheable cacheable = this.entry;
        if (cacheable == null) {
            cacheable = cacheableFactory.newCacheable(cacheManager);
        }
        this.entry = bl ? cacheable.createIdentity(object, object2) : cacheable.setIdentity(object);
        if (this.entry != null) {
            return this.entry;
        }
        this.entry = cacheable;
        return null;
    }

    public synchronized void settingIdentityComplete() {
        this.settingIdentity_ = false;
        this.notifyAll();
    }

    public synchronized Cacheable use() throws StandardException {
        while (this.settingIdentity_) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw StandardException.interrupt(interruptedException);
            }
        }
        if (!this.valid_) {
            return null;
        }
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean bl) throws StandardException {
        if (!bl) {
            CachedItem cachedItem = this;
            synchronized (cachedItem) {
                while (!this.removeOk_) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw StandardException.interrupt(interruptedException);
                    }
                }
            }
        }
        this.clean(true);
    }

    public synchronized void notifyRemover() {
        this.removeOk_ = true;
        this.notifyAll();
    }

    public synchronized void setUsed(boolean bl) {
        this.recentlyUsed_ = bl;
    }

    public synchronized boolean recentlyUsed() {
        return this.recentlyUsed_;
    }
}

