/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import sqlj.runtime.error.ProfileErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.DefaultLoader;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.SerializedProfile;
import sqlj.runtime.profile.TypeInfo;

public abstract class Profile
implements Serializable {
    private transient Loader m_loader = null;
    private transient Hashtable m_types = null;
    static final long serialVersionUID = 6176398232003186292L;
    static /* synthetic */ Class class$sqlj$runtime$profile$Profile;
    static /* synthetic */ Class class$sqlj$runtime$profile$SerializedProfile;

    public Profile(Loader loader) {
        if (loader == null) {
            loader = new DefaultLoader(null);
        }
        this.setLoader(loader);
    }

    public abstract String getProfileName();

    public abstract String getContextName();

    public abstract long getTimestamp();

    public abstract ProfileData getProfileData();

    public abstract ConnectedProfile getConnectedProfile(Connection var1) throws SQLException;

    public abstract void registerCustomization(Customization var1);

    public abstract void registerCustomization(Customization var1, Customization var2);

    public abstract void replaceCustomization(Customization var1, Customization var2);

    public abstract void deregisterCustomization(Customization var1);

    public abstract Enumeration getCustomizations();

    public Loader getLoader() {
        return this.m_loader;
    }

    private void setLoader(Loader loader) {
        this.m_loader = loader;
        this.m_types = this.newTypeTable();
    }

    private Hashtable newTypeTable() {
        Hashtable<String, Class<Object>> hashtable = new Hashtable<String, Class<Object>>();
        hashtable.put("boolean", Boolean.TYPE);
        hashtable.put("char", Character.TYPE);
        hashtable.put("byte", Byte.TYPE);
        hashtable.put("short", Short.TYPE);
        hashtable.put("int", Integer.TYPE);
        hashtable.put("long", Long.TYPE);
        hashtable.put("float", Float.TYPE);
        hashtable.put("double", Double.TYPE);
        hashtable.put("void", Void.TYPE);
        return hashtable;
    }

    public Class getJavaType(TypeInfo typeInfo) {
        return this.getJavaType(typeInfo.getJavaTypeName());
    }

    public Class getJavaType(String string) {
        Class clazz = (Class)this.m_types.get(string);
        if (clazz == null) {
            try {
                int n2 = string.lastIndexOf(91);
                if (n2 != -1) {
                    int n3 = n2 + 1;
                    String string2 = string.substring(n2 + 1);
                    clazz = (Class)this.m_types.get(string2);
                    if (clazz == null) {
                        clazz = this.m_loader.loadClass(string2);
                    }
                    int n4 = 0;
                    while (n4 < n3) {
                        clazz = Array.newInstance(clazz, 0).getClass();
                        ++n4;
                    }
                } else {
                    clazz = this.m_loader.loadClass(string);
                }
                this.m_types.put(string, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(string);
            }
        }
        return clazz;
    }

    public static Profile instantiate(Loader loader, String string) throws IOException, ClassNotFoundException {
        if (loader == null) {
            loader = new DefaultLoader(null);
        }
        Profile profile = null;
        String string2 = string.replace('.', '/').concat(".ser");
        InputStream inputStream = loader.getResourceAsStream(string2);
        if (inputStream != null) {
            profile = Profile.instantiate(loader, inputStream);
        }
        if (profile == null) {
            Class clazz;
            if ((class$sqlj$runtime$profile$Profile == null ? (class$sqlj$runtime$profile$Profile = Profile.class$("sqlj.runtime.profile.Profile")) : class$sqlj$runtime$profile$Profile).isAssignableFrom(clazz = loader.loadClass(string))) {
                try {
                    profile = (Profile)clazz.newInstance();
                    profile.setLoader(loader);
                }
                catch (Exception exception) {
                    String string3 = ProfileErrors.CANT_INSTANTIATE_PROFILE_text(string);
                    throw new ClassNotFoundException(string3);
                }
            }
            if ((class$sqlj$runtime$profile$SerializedProfile == null ? (class$sqlj$runtime$profile$SerializedProfile = Profile.class$("sqlj.runtime.profile.SerializedProfile")) : class$sqlj$runtime$profile$SerializedProfile).isAssignableFrom(clazz)) {
                SerializedProfile serializedProfile;
                try {
                    serializedProfile = (SerializedProfile)clazz.newInstance();
                }
                catch (Exception exception) {
                    String string4 = ProfileErrors.CANT_INSTANTIATE_SER_PROFILE_text(string);
                    throw new ClassNotFoundException(string4);
                }
                profile = Profile.instantiate(loader, serializedProfile.getProfileAsStream());
            } else {
                String string5 = ProfileErrors.NOT_A_PROFILE_text(string);
                throw new ClassNotFoundException(string5);
            }
        }
        return profile;
    }

    public static Profile instantiate(Loader loader, InputStream inputStream) throws ClassNotFoundException, IOException {
        if (loader == null) {
            loader = new DefaultLoader(null);
        }
        Profile profile = null;
        try {
            ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader(inputStream, loader);
            profile = (Profile)objectInputStreamWithLoader.readObject();
            objectInputStreamWithLoader.close();
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            inputStream.close();
            throw classNotFoundException;
        }
        profile.setLoader(loader);
        return profile;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private Loader m_loader;

        public ObjectInputStreamWithLoader(InputStream inputStream, Loader loader) throws IOException, StreamCorruptedException {
            super(inputStream);
            this.m_loader = loader;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            String string = objectStreamClass.getName();
            if (string.startsWith("[")) {
                return super.resolveClass(objectStreamClass);
            }
            return this.m_loader.loadClass(string);
        }
    }
}

