/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGNumberList;

public abstract class SVGUtilities
implements SVGConstants,
ErrorConstants {
    public static final short USER_SPACE_ON_USE = 1;
    public static final short OBJECT_BOUNDING_BOX = 2;
    public static final short STROKE_WIDTH = 3;

    protected SVGUtilities() {
    }

    public static Node getImportedChild(Node node) {
        return CSSEngine.getImportedChild(node);
    }

    public static Element getParentElement(Element element) {
        return CSSEngine.getParentElement(element);
    }

    public static float[] convertSVGNumberList(SVGNumberList sVGNumberList) {
        int n = sVGNumberList.getNumberOfItems();
        if (n == 0) {
            return null;
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = sVGNumberList.getItem(i).getValue();
        }
        return fArray;
    }

    public static float convertSVGNumber(String string) {
        return Float.parseFloat(string);
    }

    public static int convertSVGInteger(String string) {
        return Integer.parseInt(string);
    }

    public static float convertRatio(String string) {
        float f;
        float f2 = 1.0f;
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
            f2 = 100.0f;
        }
        if ((f = Float.parseFloat(string) / f2) < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static String getDescription(SVGElement sVGElement) {
        String string = "";
        boolean bl = false;
        Node node = sVGElement.getFirstChild();
        if (node != null && node.getNodeType() == 1) {
            String string2;
            String string3 = string2 = node.getPrefix() == null ? node.getNodeName() : node.getLocalName();
            if (string2.equals("desc")) {
                bl = ((SVGLangSpace)((Object)node)).getXMLspace().equals("preserve");
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 3) continue;
                    string = string + node.getNodeValue();
                }
            }
        }
        return bl ? XMLSupport.preserveXMLSpace(string) : XMLSupport.defaultXMLSpace(string);
    }

    public static boolean matchUserAgent(Element element, UserAgent userAgent) {
        String string;
        StringTokenizer stringTokenizer;
        String string2;
        block9: {
            if (element.hasAttributeNS(null, "systemLanguage")) {
                string2 = element.getAttributeNS(null, "systemLanguage");
                if (string2.length() == 0) {
                    return false;
                }
                stringTokenizer = new StringTokenizer(string2, ", ");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (!SVGUtilities.matchUserLanguage(string, userAgent.getLanguages())) continue;
                    break block9;
                }
                return false;
            }
        }
        if (element.hasAttributeNS(null, "requiredFeatures")) {
            string2 = element.getAttributeNS(null, "requiredFeatures");
            if (string2.length() == 0) {
                return false;
            }
            stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (userAgent.hasFeature(string)) continue;
                return false;
            }
        }
        if (element.hasAttributeNS(null, "requiredExtensions")) {
            string2 = element.getAttributeNS(null, "requiredExtensions");
            if (string2.length() == 0) {
                return false;
            }
            stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (userAgent.supportExtension(string)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean matchUserLanguage(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string.startsWith(string3)) continue;
            if (string.length() > string3.length()) {
                return string.charAt(string3.length()) == '-';
            }
            return true;
        }
        return false;
    }

    public static String getChainableAttributeNS(Element element, String string, String string2, BridgeContext bridgeContext) {
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        Element element2 = element;
        LinkedList<ParsedURL> linkedList = new LinkedList<ParsedURL>();
        String string3;
        while ((string3 = element2.getAttributeNS(string, string2)).length() <= 0) {
            String string4 = XLinkSupport.getXLinkHref(element2);
            if (string4.length() == 0) {
                return "";
            }
            SVGDocument sVGDocument = (SVGDocument)element2.getOwnerDocument();
            String string5 = ((SVGOMDocument)sVGDocument).getURL();
            ParsedURL parsedURL = new ParsedURL(string5, string4);
            if (!parsedURL.complete()) {
                throw new BridgeException(element2, "uri.malformed", new Object[]{string4});
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                if (!parsedURL.equals(iterator.next())) continue;
                throw new BridgeException(element2, "xlink.href.circularDependencies", new Object[]{string4});
            }
            try {
                URIResolver uRIResolver = new URIResolver(sVGDocument, documentLoader);
                element2 = uRIResolver.getElement(parsedURL.toString(), element2);
                linkedList.add(parsedURL);
            }
            catch (IOException iOException) {
                throw new BridgeException(element2, "uri.io", new Object[]{string4});
            }
            catch (SecurityException securityException) {
                throw new BridgeException(element2, "uri.unsecure", new Object[]{string4});
            }
        }
        return string3;
    }

    public static Point2D convertPoint(String string, String string2, String string3, String string4, short s, UnitProcessor.Context context) {
        float f;
        float f2;
        switch (s) {
            case 2: {
                f2 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(string, string2, context);
                f = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(string3, string4, context);
                break;
            }
            case 1: {
                f2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, string2, context);
                f = UnitProcessor.svgVerticalCoordinateToUserSpace(string3, string4, context);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return new Point2D.Float(f2, f);
    }

    public static float convertLength(String string, String string2, short s, UnitProcessor.Context context) {
        switch (s) {
            case 2: {
                return UnitProcessor.svgOtherLengthToObjectBoundingBox(string, string2, context);
            }
            case 1: {
                return UnitProcessor.svgOtherLengthToUserSpace(string, string2, context);
            }
        }
        throw new Error();
    }

    public static Rectangle2D convertMaskRegion(Element element, Element element2, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = element.getAttributeNS(null, "x");
        if (string5.length() == 0) {
            string5 = "-10%";
        }
        if ((string4 = element.getAttributeNS(null, "y")).length() == 0) {
            string4 = "-10%";
        }
        if ((string3 = element.getAttributeNS(null, "width")).length() == 0) {
            string3 = "120%";
        }
        if ((string2 = element.getAttributeNS(null, "height")).length() == 0) {
            string2 = "120%";
        }
        short s = (string = element.getAttributeNS(null, "maskUnits")).length() == 0 ? (short)2 : (short)SVGUtilities.parseCoordinateSystem(element, "maskUnits", string);
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element2);
        return SVGUtilities.convertRegion(string5, string4, string3, string2, s, graphicsNode, context);
    }

    public static Rectangle2D convertPatternRegion(Element element, Element element2, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        String string;
        String string2;
        String string3 = SVGUtilities.getChainableAttributeNS(element, null, "x", bridgeContext);
        if (string3.length() == 0) {
            string3 = "0";
        }
        if ((string2 = SVGUtilities.getChainableAttributeNS(element, null, "y", bridgeContext)).length() == 0) {
            string2 = "0";
        }
        if ((string = SVGUtilities.getChainableAttributeNS(element, null, "width", bridgeContext)).length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"width"});
        }
        String string4 = SVGUtilities.getChainableAttributeNS(element, null, "height", bridgeContext);
        if (string4.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"height"});
        }
        String string5 = SVGUtilities.getChainableAttributeNS(element, null, "patternUnits", bridgeContext);
        short s = string5.length() == 0 ? (short)2 : (short)SVGUtilities.parseCoordinateSystem(element, "patternUnits", string5);
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element2);
        return SVGUtilities.convertRegion(string3, string2, string, string4, s, graphicsNode, context);
    }

    public static float[] convertFilterRes(Element element, BridgeContext bridgeContext) {
        float[] fArray = new float[2];
        String string = SVGUtilities.getChainableAttributeNS(element, null, "filterRes", bridgeContext);
        Float[] floatArray = SVGUtilities.convertSVGNumberOptionalNumber(element, "filterRes", string);
        if (fArray[0] < 0.0f || fArray[1] < 0.0f) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"filterRes", string});
        }
        if (floatArray[0] == null) {
            fArray[0] = -1.0f;
        } else {
            fArray[0] = floatArray[0].floatValue();
            if (fArray[0] < 0.0f) {
                throw new BridgeException(element, "attribute.malformed", new Object[]{"filterRes", string});
            }
        }
        if (floatArray[1] == null) {
            fArray[1] = fArray[0];
        } else {
            fArray[1] = floatArray[1].floatValue();
            if (fArray[1] < 0.0f) {
                throw new BridgeException(element, "attribute.malformed", new Object[]{"filterRes", string});
            }
        }
        return fArray;
    }

    public static Float[] convertSVGNumberOptionalNumber(Element element, String string, String string2) {
        Float[] floatArray = new Float[2];
        if (string2.length() == 0) {
            return floatArray;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            floatArray[0] = new Float(Float.parseFloat(stringTokenizer.nextToken()));
            if (stringTokenizer.hasMoreTokens()) {
                floatArray[1] = new Float(Float.parseFloat(stringTokenizer.nextToken()));
            }
            if (stringTokenizer.hasMoreTokens()) {
                throw new BridgeException(element, "attribute.malformed", new Object[]{string, string2});
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{string, string2, numberFormatException});
        }
        return floatArray;
    }

    public static Rectangle2D convertFilterChainRegion(Element element, Element element2, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8 = SVGUtilities.getChainableAttributeNS(element, null, "x", bridgeContext);
        if (string8.length() == 0) {
            string8 = "-10%";
        }
        if ((string7 = SVGUtilities.getChainableAttributeNS(element, null, "y", bridgeContext)).length() == 0) {
            string7 = "-10%";
        }
        if ((string6 = SVGUtilities.getChainableAttributeNS(element, null, "width", bridgeContext)).length() == 0) {
            string6 = "120%";
        }
        if ((string5 = SVGUtilities.getChainableAttributeNS(element, null, "height", bridgeContext)).length() == 0) {
            string5 = "120%";
        }
        short s = (string4 = SVGUtilities.getChainableAttributeNS(element, null, "filterUnits", bridgeContext)).length() == 0 ? (short)2 : (short)SVGUtilities.parseCoordinateSystem(element, "filterUnits", string4);
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element2);
        Rectangle2D rectangle2D = SVGUtilities.convertRegion(string8, string7, string6, string5, s, graphicsNode, context);
        string4 = SVGUtilities.getChainableAttributeNS(element, null, "filterMarginsUnits", bridgeContext);
        s = string4.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element, "filterMarginsUnits", string4);
        String string9 = element.getAttributeNS(null, "mx");
        if (string9.length() == 0) {
            string9 = "0";
        }
        if ((string3 = element.getAttributeNS(null, "my")).length() == 0) {
            string3 = "0";
        }
        if ((string2 = element.getAttributeNS(null, "mw")).length() == 0) {
            string2 = "0";
        }
        if ((string = element.getAttributeNS(null, "mh")).length() == 0) {
            string = "0";
        }
        return SVGUtilities.extendRegion(string9, string3, string2, string, s, graphicsNode, rectangle2D, context);
    }

    protected static Rectangle2D extendRegion(String string, String string2, String string3, String string4, short s, GraphicsNode graphicsNode, Rectangle2D rectangle2D, UnitProcessor.Context context) {
        float f;
        float f2;
        float f3;
        float f4;
        switch (s) {
            case 1: {
                f4 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "mx", context);
                f3 = UnitProcessor.svgVerticalCoordinateToUserSpace(string2, "my", context);
                f2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string3, "mw", context);
                f = UnitProcessor.svgVerticalCoordinateToUserSpace(string4, "mh", context);
                break;
            }
            case 2: {
                Rectangle2D rectangle2D2 = graphicsNode.getGeometryBounds();
                if (rectangle2D2 == null) {
                    f = 0.0f;
                    f2 = 0.0f;
                    f3 = 0.0f;
                    f4 = 0.0f;
                    break;
                }
                f4 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(string, "mx", context);
                f4 = (float)((double)f4 * rectangle2D2.getWidth());
                f3 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(string2, "my", context);
                f3 = (float)((double)f3 * rectangle2D2.getHeight());
                f2 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(string3, "mw", context);
                f2 = (float)((double)f2 * rectangle2D2.getWidth());
                f = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(string4, "mh", context);
                f = (float)((double)f * rectangle2D2.getHeight());
                break;
            }
            default: {
                throw new Error();
            }
        }
        rectangle2D.setRect(rectangle2D.getX() + (double)f4, rectangle2D.getY() + (double)f3, rectangle2D.getWidth() + (double)f2, rectangle2D.getHeight() + (double)f);
        return rectangle2D;
    }

    public static Rectangle2D convertFilterPrimitiveRegion(Element element, Element element2, GraphicsNode graphicsNode, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, BridgeContext bridgeContext) {
        String string;
        String string2;
        String string3;
        Object object;
        Rectangle2D rectangle2D3;
        Node node = element.getParentNode();
        String string4 = "";
        if (node != null && node.getNodeType() == 1) {
            Element element3 = (Element)node;
            string4 = SVGUtilities.getChainableAttributeNS(element3, null, "primitiveUnits", bridgeContext);
        }
        short s = string4.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element, "filterUnits", string4);
        String string5 = element.getAttributeNS(null, "x");
        String string6 = element.getAttributeNS(null, "y");
        String string7 = element.getAttributeNS(null, "width");
        String string8 = element.getAttributeNS(null, "height");
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element2);
        switch (s) {
            case 2: {
                rectangle2D3 = graphicsNode.getGeometryBounds();
                if (rectangle2D3 == null) break;
                if (string5.length() != 0) {
                    d = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(string5, "x", context);
                    d = rectangle2D3.getX() + d * rectangle2D3.getWidth();
                }
                if (string6.length() != 0) {
                    d2 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(string6, "y", context);
                    d2 = rectangle2D3.getY() + d2 * rectangle2D3.getHeight();
                }
                if (string7.length() != 0) {
                    d3 = UnitProcessor.svgHorizontalLengthToObjectBoundingBox(string7, "width", context);
                    d3 *= rectangle2D3.getWidth();
                }
                if (string8.length() == 0) break;
                d4 = UnitProcessor.svgVerticalLengthToObjectBoundingBox(string8, "height", context);
                d4 *= rectangle2D3.getHeight();
                break;
            }
            case 1: {
                if (string5.length() != 0) {
                    d = UnitProcessor.svgHorizontalCoordinateToUserSpace(string5, "x", context);
                }
                if (string6.length() != 0) {
                    d2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string6, "y", context);
                }
                if (string7.length() != 0) {
                    d3 = UnitProcessor.svgHorizontalLengthToUserSpace(string7, "width", context);
                }
                if (string8.length() == 0) break;
                d4 = UnitProcessor.svgVerticalLengthToUserSpace(string8, "height", context);
                break;
            }
            default: {
                throw new Error();
            }
        }
        rectangle2D3 = new Rectangle2D.Double(d, d2, d3, d4);
        string4 = "";
        if (node != null && node.getNodeType() == 1) {
            object = (Element)node;
            string4 = SVGUtilities.getChainableAttributeNS((Element)object, null, "filterPrimitiveMarginsUnits", bridgeContext);
        }
        s = string4.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element, "filterPrimitiveMarginsUnits", string4);
        object = element.getAttributeNS(null, "mx");
        if (((String)object).length() == 0) {
            object = "0";
        }
        if ((string3 = element.getAttributeNS(null, "my")).length() == 0) {
            string3 = "0";
        }
        if ((string2 = element.getAttributeNS(null, "mw")).length() == 0) {
            string2 = "0";
        }
        if ((string = element.getAttributeNS(null, "mh")).length() == 0) {
            string = "0";
        }
        rectangle2D3 = SVGUtilities.extendRegion((String)object, string3, string2, string, s, graphicsNode, rectangle2D3, context);
        Rectangle2D.intersect(rectangle2D3, rectangle2D2, rectangle2D3);
        return rectangle2D3;
    }

    public static short parseCoordinateSystem(Element element, String string, String string2) {
        if ("userSpaceOnUse".equals(string2)) {
            return 1;
        }
        if ("objectBoundingBox".equals(string2)) {
            return 2;
        }
        throw new BridgeException(element, "attribute.malformed", new Object[]{string, string2});
    }

    public static short parseMarkerCoordinateSystem(Element element, String string, String string2) {
        if ("userSpaceOnUse".equals(string2)) {
            return 1;
        }
        if ("strokeWidth".equals(string2)) {
            return 3;
        }
        throw new BridgeException(element, "attribute.malformed", new Object[]{string, string2});
    }

    protected static Rectangle2D convertRegion(String string, String string2, String string3, String string4, short s, GraphicsNode graphicsNode, UnitProcessor.Context context) {
        double d;
        double d2;
        double d3;
        double d4;
        switch (s) {
            case 2: {
                d4 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(string, "x", context);
                d3 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(string2, "y", context);
                d2 = UnitProcessor.svgHorizontalLengthToObjectBoundingBox(string3, "width", context);
                d = UnitProcessor.svgVerticalLengthToObjectBoundingBox(string4, "height", context);
                Rectangle2D rectangle2D = graphicsNode.getGeometryBounds();
                if (rectangle2D != null) {
                    d4 = rectangle2D.getX() + d4 * rectangle2D.getWidth();
                    d3 = rectangle2D.getY() + d3 * rectangle2D.getHeight();
                    d2 *= rectangle2D.getWidth();
                    d *= rectangle2D.getHeight();
                    break;
                }
                d = 0.0;
                d2 = 0.0;
                d3 = 0.0;
                d4 = 0.0;
                break;
            }
            case 1: {
                d4 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
                d3 = UnitProcessor.svgVerticalCoordinateToUserSpace(string2, "y", context);
                d2 = UnitProcessor.svgHorizontalLengthToUserSpace(string3, "width", context);
                d = UnitProcessor.svgVerticalLengthToUserSpace(string4, "height", context);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return new Rectangle2D.Double(d4, d3, d2, d);
    }

    public static AffineTransform convertTransform(Element element, String string, String string2) {
        try {
            return AWTTransformProducer.createAffineTransform(string2);
        }
        catch (ParseException parseException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{string, string2, parseException});
        }
    }

    public static AffineTransform toObjectBBox(AffineTransform affineTransform, GraphicsNode graphicsNode) {
        AffineTransform affineTransform2 = new AffineTransform();
        Rectangle2D rectangle2D = graphicsNode.getGeometryBounds();
        if (rectangle2D != null) {
            affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
            affineTransform2.scale(rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        affineTransform2.concatenate(affineTransform);
        return affineTransform2;
    }

    public static Rectangle2D toObjectBBox(Rectangle2D rectangle2D, GraphicsNode graphicsNode) {
        Rectangle2D rectangle2D2 = graphicsNode.getGeometryBounds();
        if (rectangle2D2 != null) {
            return new Rectangle2D.Double(rectangle2D2.getX() + rectangle2D.getX() * rectangle2D2.getWidth(), rectangle2D2.getY() + rectangle2D.getY() * rectangle2D2.getHeight(), rectangle2D.getWidth() * rectangle2D2.getWidth(), rectangle2D.getHeight() * rectangle2D2.getHeight());
        }
        return new Rectangle2D.Double();
    }
}

