/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.util.ObjectArray;

public abstract class Prepared {
    protected Session session;
    protected String sql;
    protected int headPos = -1;
    protected ObjectArray parameters;
    private long modificationId;
    private Command command;
    private int objectId;
    protected boolean prepareAlways;
    private int currentRowNumber;

    public Prepared(Session session) {
        this.session = session;
        this.modificationId = session.getDatabase().getModificationMetaId();
    }

    public boolean needRecompile() throws SQLException {
        Database db = this.session.getDatabase();
        if (db == null) {
            throw Message.getSQLException(90067);
        }
        return SysProperties.RECOMPILE_ALWAYS || this.prepareAlways || this.modificationId < db.getModificationMetaId();
    }

    public abstract boolean isTransactional();

    public boolean isReadOnly() {
        return false;
    }

    long getModificationId() {
        return this.modificationId;
    }

    void setModificationId(long id) {
        this.modificationId = id;
    }

    public void setParameterList(ObjectArray parameters) {
        this.parameters = parameters;
    }

    public ObjectArray getParameters() {
        return this.parameters;
    }

    protected void checkParameters() throws SQLException {
        for (int i = 0; this.parameters != null && i < this.parameters.size(); ++i) {
            Parameter param = (Parameter)this.parameters.get(i);
            param.checkSet();
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean isQuery() {
        return false;
    }

    public void prepare() throws SQLException {
    }

    public int update() throws SQLException {
        throw Message.getSQLException(90001);
    }

    public LocalResult query(int maxrows) throws SQLException {
        throw Message.getSQLException(90002);
    }

    public abstract LocalResult queryMeta() throws SQLException;

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public String getSQL() {
        return this.sql;
    }

    protected int getObjectId(boolean needFresh, boolean dataFile) {
        Database db = this.session.getDatabase();
        int id = this.objectId;
        if (id == 0) {
            id = db.allocateObjectId(needFresh, dataFile);
        }
        this.objectId = 0;
        return id;
    }

    public String getPlanSQL() {
        return null;
    }

    public void checkCancelled() throws SQLException {
        if (this.command != null) {
            this.command.checkCancelled();
        } else {
            this.session.checkCancelled();
        }
    }

    public void setObjectId(int i) {
        this.objectId = i;
    }

    public void setHeadPos(int headPos) {
        this.headPos = headPos;
    }

    public void setSession(Session currentSession) {
        this.session = currentSession;
    }

    void trace() throws SQLException {
        if (this.session.getTrace().info()) {
            StringBuffer buff = new StringBuffer();
            buff.append(this.sql);
            if (this.parameters.size() > 0) {
                buff.append(" {");
                for (int i = 0; i < this.parameters.size(); ++i) {
                    if (i > 0) {
                        buff.append(", ");
                    }
                    buff.append(i + 1);
                    buff.append(": ");
                    Expression e = (Expression)this.parameters.get(i);
                    buff.append(e.getValue(this.session).getSQL());
                }
                buff.append("};");
            } else {
                buff.append(';');
            }
            this.session.getTrace().infoSQL(buff.toString());
        }
    }

    public void setPrepareAlways(boolean prepareAlways) {
        this.prepareAlways = prepareAlways;
    }

    protected void setCurrentRowNumber(int rowNumber) {
        this.currentRowNumber = rowNumber;
    }

    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }
}

