/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.c.ic;
import javax.transaction.xa.Xid;

public class DB2Xid
implements Xid {
    private int formatID_;
    private int gtrid_length_;
    private int bqual_length_;
    private byte[] data_;
    private static final int XidDATASIZE = 128;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private static final String hextab_ = "0123456789ABCDEF";

    public DB2Xid() {
        this.data_ = new byte[128];
        this.gtrid_length_ = 0;
        this.bqual_length_ = 0;
        this.formatID_ = -1;
    }

    public DB2Xid(int n2, byte[] byArray, byte[] byArray2) {
        this.formatID_ = n2;
        this.gtrid_length_ = byArray.length;
        this.bqual_length_ = byArray2.length;
        this.data_ = new byte[128];
        System.arraycopy(byArray, 0, this.data_, 0, this.gtrid_length_);
        System.arraycopy(byArray2, 0, this.data_, this.gtrid_length_, this.bqual_length_);
    }

    public String toString() {
        int n2 = this.gtrid_length_ + this.bqual_length_;
        StringBuffer stringBuffer = new StringBuffer(n2 + n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.data_[n3] & 0xFF;
            stringBuffer.append(hextab_.charAt(n4 / 16));
            stringBuffer.append(hextab_.charAt(n4 & 0xF));
            if ((n3 + 1) % 4 == 0 && n3 + 1 < n2) {
                stringBuffer.append(" ");
            }
            ++n3;
        }
        String string = "{DB2Xid: formatID(" + this.formatID_ + "), " + "gtrid_length(" + this.gtrid_length_ + "), " + "bqual_length(" + this.bqual_length_ + "), " + "data(" + stringBuffer.toString() + ")" + "}";
        return string;
    }

    public byte[] getBranchQualifier() {
        byte[] byArray = new byte[this.bqual_length_];
        System.arraycopy(this.data_, this.gtrid_length_, byArray, 0, this.bqual_length_);
        return byArray;
    }

    public void setBranchQualifier(byte[] byArray) {
        this.bqual_length_ = byArray.length > 64 ? 64 : byArray.length;
        System.arraycopy(byArray, 0, this.data_, this.gtrid_length_, this.bqual_length_);
    }

    public int getFormatId() {
        return this.formatID_;
    }

    public void setFormatID(int n2) {
        this.formatID_ = n2;
    }

    public byte[] getGlobalTransactionId() {
        byte[] byArray = new byte[this.gtrid_length_];
        System.arraycopy(this.data_, 0, byArray, 0, this.gtrid_length_);
        return byArray;
    }

    public byte[] getData() {
        return this.data_;
    }

    public int getGtridLength() {
        return this.gtrid_length_;
    }

    public int getBqualLength() {
        return this.bqual_length_;
    }

    public int hashCode() {
        if (this.formatID_ == -1) {
            return -1;
        }
        return this.formatID_ + this.gtrid_length_ - this.bqual_length_;
    }

    public boolean equals(Object object) {
        return ic.a(this, (Xid)object);
    }
}

