/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.generator;

import org.apache.poi.generator.RecordUtil;

public class HDFRecordUtil
extends RecordUtil {
    public static String getType(String size, String type, int padTo) {
        return type;
    }

    public static String getType1stCap(String size, String type, int padTo) {
        StringBuffer result = new StringBuffer();
        result.append(type);
        result = HDFRecordUtil.pad(result, padTo);
        result.setCharAt(0, Character.toUpperCase(result.charAt(0)));
        return result.toString();
    }

    public static String getBitFieldFunction(String name, String bitMask, String parentType, String withType) {
        String type = HDFRecordUtil.getBitFieldType(name, bitMask, parentType);
        String retVal = new String();
        if (withType.equals("true")) {
            retVal = type + " ";
        }
        retVal = type.equals("boolean") ? retVal + "is" + HDFRecordUtil.getFieldName1stCap(name, 0) : retVal + "get" + HDFRecordUtil.getFieldName1stCap(name, 0);
        return retVal;
    }

    public static String getBitFieldGet(String name, String bitMask, String parentType, String parentField) {
        String type = HDFRecordUtil.getBitFieldType(name, bitMask, parentType);
        String retVal = null;
        retVal = type.equals("boolean") ? name + ".isSet(" + parentField + ");" : "( " + type + " )" + name + ".getValue(" + parentField + ");";
        return retVal;
    }

    public static String getBitFieldSet(String name, String bitMask, String parentType, String parentField) {
        String type = HDFRecordUtil.getBitFieldType(name, bitMask, parentType);
        String retVal = null;
        retVal = type.equals("boolean") ? "(" + parentType + ")" + HDFRecordUtil.getFieldName(name, 0) + ".setBoolean(" + parentField + ", value)" : "(" + parentType + ")" + HDFRecordUtil.getFieldName(name, 0) + ".setValue(" + parentField + ", value)";
        return retVal;
    }

    public static String getBitFieldType(String name, String bitMask, String parentType) {
        int parentSize = 0;
        int numBits = 0;
        int mask = (int)Long.parseLong(bitMask.substring(2), 16);
        if (parentType.equals("byte")) {
            parentSize = 8;
        } else if (parentType.equals("short")) {
            parentSize = 16;
        } else if (parentType.equals("int")) {
            parentSize = 32;
        }
        for (int x = 0; x < parentSize; ++x) {
            int temp = mask;
            numBits = (byte)(numBits + (temp >> x & 1));
        }
        if (numBits == 1) {
            return "boolean";
        }
        if (numBits < 8) {
            return "byte";
        }
        if (numBits < 16) {
            return "short";
        }
        return "int";
    }
}

