/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class FilePassRecord
extends Record {
    public static final short sid = 47;
    private int field_1_encryptedpassword;

    public FilePassRecord() {
    }

    public FilePassRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 47) {
            throw new RecordFormatException("NOT A FILEPASS RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_encryptedpassword = in.readInt();
        throw new RecordFormatException("HSSF does not currently support encrypted workbooks");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FILEPASS]\n");
        buffer.append("    .password        = ").append(this.field_1_encryptedpassword).append("\n");
        buffer.append("[/FILEPASS]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)47);
        LittleEndian.putShort(data, 2 + offset, (short)4);
        LittleEndian.putInt(data, 4 + offset, (short)this.field_1_encryptedpassword);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 47;
    }

    public Object clone() {
        FilePassRecord rec = new FilePassRecord();
        rec.field_1_encryptedpassword = this.field_1_encryptedpassword;
        return rec;
    }
}

