/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;

public class AlterTableAlterColumn
extends SchemaCommand {
    public static final int NOT_NULL = 0;
    public static final int NULL = 1;
    public static final int DEFAULT = 2;
    public static final int RESTART = 3;
    public static final int CHANGE_TYPE = 4;
    public static final int ADD = 5;
    public static final int DROP = 6;
    public static final int SELECTIVITY = 7;
    private Table table;
    private Column oldColumn;
    private Column newColumn;
    private int type;
    private Expression defaultExpression;
    private long newStart;
    private String addBefore;

    public AlterTableAlterColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setOldColumn(Column oldColumn) {
        this.oldColumn = oldColumn;
    }

    public void setAddBefore(String before) {
        this.addBefore = before;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        this.session.getUser().checkRight(this.table, 15);
        this.table.checkSupportAlter();
        this.table.lock(this.session, true, true);
        Sequence sequence = this.oldColumn == null ? null : this.oldColumn.getSequence();
        switch (this.type) {
            case 0: {
                if (!this.oldColumn.getNullable()) break;
                this.checkNoNullValues();
                this.oldColumn.setNullable(false);
                db.update(this.session, this.table);
                break;
            }
            case 1: {
                if (this.oldColumn.getNullable()) break;
                this.checkNullable();
                this.oldColumn.setNullable(true);
                db.update(this.session, this.table);
                break;
            }
            case 2: {
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, this.defaultExpression);
                this.removeSequence(this.session, sequence);
                db.update(this.session, this.table);
                break;
            }
            case 3: {
                if (sequence == null) {
                    throw Message.getSQLException(90036, this.oldColumn.getSQL());
                }
                sequence.setStartValue(this.newStart);
                db.update(this.session, sequence);
                break;
            }
            case 4: {
                this.checkNoViews();
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, null);
                this.oldColumn.setConvertNullToDefault(false);
                if (this.oldColumn.getNullable() && !this.newColumn.getNullable()) {
                    this.checkNoNullValues();
                } else if (!this.oldColumn.getNullable() && this.newColumn.getNullable()) {
                    this.checkNullable();
                }
                this.convertToIdentityIfRequired(this.newColumn);
                this.copyData();
                break;
            }
            case 5: {
                this.checkNoViews();
                this.convertToIdentityIfRequired(this.newColumn);
                this.copyData();
                break;
            }
            case 6: {
                this.checkNoViews();
                if (this.table.getColumns().length == 1) {
                    throw Message.getSQLException(90084, this.oldColumn.getSQL());
                }
                this.table.checkColumnIsNotReferenced(this.oldColumn);
                this.dropSingleColumnIndexes();
                this.copyData();
                break;
            }
            case 7: {
                this.oldColumn.setSelectivity((int)this.newStart);
                db.update(this.session, this.table);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    private void convertToIdentityIfRequired(Column c) throws SQLException {
        if (c.getAutoIncrement()) {
            c.setOriginalSQL("IDENTITY");
        }
    }

    private void removeSequence(Session session, Sequence sequence) throws SQLException {
        if (sequence != null) {
            this.table.removeSequence(session, sequence);
            sequence.setBelongsToTable(false);
            Database db = session.getDatabase();
            db.removeSchemaObject(session, sequence);
        }
    }

    private void checkNoViews() throws SQLException {
        ObjectArray children = this.table.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            DbObject child = (DbObject)children.get(i);
            if (child.getType() != 0) continue;
            throw Message.getSQLException(90122, new String[]{this.table.getName(), child.getName()});
        }
    }

    private void copyData() throws SQLException {
        int i;
        int position;
        Database db = this.session.getDatabase();
        String tempName = db.getTempTableName(this.session.getId());
        Column[] columns = this.table.getColumns();
        ObjectArray newColumns = new ObjectArray();
        for (int i2 = 0; i2 < columns.length; ++i2) {
            Column col = columns[i2].getClone();
            newColumns.add(col);
        }
        if (this.type == 6) {
            position = this.oldColumn.getColumnId();
            newColumns.remove(position);
        } else if (this.type == 5) {
            position = this.addBefore == null ? columns.length : this.table.getColumn(this.addBefore).getColumnId();
            newColumns.add(position, this.newColumn);
        } else if (this.type == 4) {
            position = this.oldColumn.getColumnId();
            newColumns.remove(position);
            newColumns.add(position, this.newColumn);
        }
        boolean persistent = this.table.isPersistent();
        int id = -1;
        TableData newTable = this.getSchema().createTable(tempName, id, newColumns, persistent, false);
        newTable.setComment(this.table.getComment());
        this.execute(newTable.getCreateSQL(), true);
        newTable = (TableData)newTable.getSchema().getTableOrView(this.session, newTable.getName());
        ObjectArray children = this.table.getChildren();
        for (int i3 = 0; i3 < children.size(); ++i3) {
            ConstraintReferential r;
            String createSQL;
            DbObject child = (DbObject)children.get(i3);
            if (child instanceof Sequence || (createSQL = child.getCreateSQL()) == null) continue;
            if (child.getType() == 0) {
                throw Message.getInternalError();
            }
            String quotedName = Parser.quoteIdentifier(tempName + "_" + child.getName());
            String sql = null;
            if (child instanceof ConstraintReferential && (r = (ConstraintReferential)child).getTable() != this.table) {
                sql = r.getCreateSQLForCopy(r.getTable(), newTable, quotedName, false);
            }
            if (sql == null) {
                sql = child.getCreateSQLForCopy(newTable, quotedName);
            }
            if (sql == null) continue;
            this.execute(sql, true);
        }
        StringBuffer columnList = new StringBuffer();
        for (int i4 = 0; i4 < newColumns.size(); ++i4) {
            Column nc = (Column)newColumns.get(i4);
            if (this.type == 5 && nc == this.newColumn) continue;
            if (columnList.length() > 0) {
                columnList.append(", ");
            }
            columnList.append(nc.getSQL());
        }
        StringBuffer buff = new StringBuffer();
        buff.append("INSERT INTO ");
        buff.append(newTable.getSQL());
        buff.append("(");
        buff.append(columnList);
        buff.append(") SELECT ");
        if (columnList.length() == 0) {
            buff.append("*");
        } else {
            buff.append(columnList);
        }
        buff.append(" FROM ");
        buff.append(this.table.getSQL());
        String sql = buff.toString();
        newTable.setCheckForeignKeyConstraints(this.session, false, false);
        try {
            this.execute(sql, false);
        }
        catch (SQLException e) {
            this.unlinkSequences(newTable);
            this.execute("DROP TABLE " + newTable.getSQL(), true);
            throw e;
        }
        newTable.setCheckForeignKeyConstraints(this.session, true, false);
        String tableName = this.table.getName();
        this.table.setModified();
        for (i = 0; i < columns.length; ++i) {
            Sequence seq = columns[i].getSequence();
            if (seq == null) continue;
            this.table.removeSequence(this.session, seq);
            columns[i].setSequence(null);
        }
        this.execute("DROP TABLE " + this.table.getSQL(), true);
        db.renameSchemaObject(this.session, newTable, tableName);
        children = newTable.getChildren();
        for (i = 0; i < children.size(); ++i) {
            String name;
            DbObject child = (DbObject)children.get(i);
            if (child instanceof Sequence || (name = child.getName()) == null || child.getCreateSQL() == null || !name.startsWith(tempName + "_")) continue;
            name = name.substring(tempName.length() + 1);
            db.renameSchemaObject(this.session, (SchemaObject)child, name);
        }
    }

    private void unlinkSequences(Table table) throws SQLException {
        Column[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Sequence seq = columns[i].getSequence();
            if (seq == null) continue;
            table.removeSequence(this.session, seq);
            columns[i].setSequence(null);
        }
    }

    private void execute(String sql, boolean ddl) throws SQLException {
        Prepared command = this.session.prepare(sql);
        command.update();
        if (ddl && this.session.getDatabase().isMultiVersion()) {
            this.session.commit(true);
        }
    }

    private void dropSingleColumnIndexes() throws SQLException {
        Database db = this.session.getDatabase();
        ObjectArray indexes = this.table.getIndexes();
        for (int i = 0; i < indexes.size(); ++i) {
            Index index = (Index)indexes.get(i);
            if (index.getCreateSQL() == null) continue;
            boolean dropIndex = false;
            Column[] cols = index.getColumns();
            for (int j = 0; j < cols.length; ++j) {
                if (cols[j] != this.oldColumn) continue;
                if (cols.length == 1) {
                    dropIndex = true;
                    continue;
                }
                throw Message.getSQLException(90075, index.getSQL());
            }
            if (!dropIndex) continue;
            db.removeSchemaObject(this.session, index);
            indexes = this.table.getIndexes();
            i = -1;
        }
    }

    private void checkNullable() throws SQLException {
        ObjectArray indexes = this.table.getIndexes();
        for (int i = 0; i < indexes.size(); ++i) {
            IndexType indexType;
            Index index = (Index)indexes.get(i);
            if (index.getColumnIndex(this.oldColumn) < 0 || !(indexType = index.getIndexType()).isPrimaryKey() && !indexType.isHash()) continue;
            throw Message.getSQLException(90075, index.getSQL());
        }
    }

    private void checkNoNullValues() throws SQLException {
        String sql = "SELECT COUNT(*) FROM " + this.table.getSQL() + " WHERE " + this.oldColumn.getSQL() + " IS NULL";
        Prepared command = this.session.prepare(sql);
        LocalResult result = command.query(0);
        result.next();
        if (result.currentRow()[0].getInt() > 0) {
            throw Message.getSQLException(90081, this.oldColumn.getSQL());
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setStartWith(long start) {
        this.newStart = start;
    }

    public void setDefaultExpression(Expression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public void setNewColumn(Column newColumn) {
        this.newColumn = newColumn;
    }
}

