/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;

class PermissionsCacheable
implements Cacheable {
    protected final DataDictionaryImpl dd;
    private PermissionsDescriptor permissions;

    PermissionsCacheable(DataDictionaryImpl dataDictionaryImpl) {
        this.dd = dataDictionaryImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cacheable setIdentity(Object object) throws StandardException {
        if (object instanceof TablePermsDescriptor) {
            TablePermsDescriptor tablePermsDescriptor = (TablePermsDescriptor)object;
            this.permissions = this.dd.getUncachedTablePermsDescriptor(tablePermsDescriptor);
            if (this.permissions == null) {
                TableDescriptor tableDescriptor = this.dd.getTableDescriptor(tablePermsDescriptor.getTableUUID());
                SchemaDescriptor schemaDescriptor = tableDescriptor.getSchemaDescriptor();
                this.permissions = schemaDescriptor.isSystemSchema() ? new TablePermsDescriptor(this.dd, tablePermsDescriptor.getGrantee(), null, tablePermsDescriptor.getTableUUID(), "Y", "N", "N", "N", "N", "N") : (tablePermsDescriptor.getGrantee().equals(schemaDescriptor.getAuthorizationId()) ? new TablePermsDescriptor(this.dd, tablePermsDescriptor.getGrantee(), "_SYSTEM", tablePermsDescriptor.getTableUUID(), "Y", "Y", "Y", "Y", "Y", "Y") : new TablePermsDescriptor(this.dd, tablePermsDescriptor.getGrantee(), null, tablePermsDescriptor.getTableUUID(), "N", "N", "N", "N", "N", "N"));
            }
        } else if (object instanceof ColPermsDescriptor) {
            ColPermsDescriptor colPermsDescriptor = (ColPermsDescriptor)object;
            this.permissions = this.dd.getUncachedColPermsDescriptor(colPermsDescriptor);
            if (this.permissions == null) {
                this.permissions = new ColPermsDescriptor(this.dd, colPermsDescriptor.getGrantee(), null, colPermsDescriptor.getTableUUID(), colPermsDescriptor.getType(), null);
            }
        } else {
            if (!(object instanceof RoutinePermsDescriptor)) return null;
            RoutinePermsDescriptor routinePermsDescriptor = (RoutinePermsDescriptor)object;
            this.permissions = this.dd.getUncachedRoutinePermsDescriptor(routinePermsDescriptor);
            if (this.permissions == null) {
                try {
                    AliasDescriptor aliasDescriptor = this.dd.getAliasDescriptor(routinePermsDescriptor.getRoutineUUID());
                    SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(aliasDescriptor.getSchemaUUID(), ConnectionUtil.getCurrentLCC().getTransactionExecute());
                    if (schemaDescriptor.isSystemSchema() && !schemaDescriptor.isSchemaWithGrantableRoutines()) {
                        this.permissions = new RoutinePermsDescriptor(this.dd, routinePermsDescriptor.getGrantee(), null, routinePermsDescriptor.getRoutineUUID(), true);
                    } else if (routinePermsDescriptor.getGrantee().equals(schemaDescriptor.getAuthorizationId())) {
                        this.permissions = new RoutinePermsDescriptor(this.dd, routinePermsDescriptor.getGrantee(), "_SYSTEM", routinePermsDescriptor.getRoutineUUID(), true);
                    }
                }
                catch (SQLException sQLException) {
                    throw StandardException.plainWrapException(sQLException);
                }
            }
        }
        if (this.permissions == null) return null;
        return this;
    }

    public Cacheable createIdentity(Object object, Object object2) throws StandardException {
        if (object == null) {
            return null;
        }
        this.permissions = (PermissionsDescriptor)((PermissionsDescriptor)object).clone();
        return this;
    }

    public void clearIdentity() {
        this.permissions = null;
    }

    public Object getIdentity() {
        return this.permissions;
    }

    public boolean isDirty() {
        return false;
    }

    public void clean(boolean bl) throws StandardException {
    }
}

