/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.ParentAwareRecord;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.util.LittleEndian;

public class TextHeaderAtom
extends RecordAtom
implements ParentAwareRecord {
    private byte[] _header;
    private static long _type = 3999L;
    private RecordContainer parentRecord;
    public static final int TITLE_TYPE = 0;
    public static final int BODY_TYPE = 1;
    public static final int NOTES_TYPE = 2;
    public static final int OTHER_TYPE = 4;
    public static final int CENTRE_BODY_TYPE = 5;
    public static final int CENTER_TITLE_TYPE = 6;
    public static final int HALF_BODY_TYPE = 7;
    public static final int QUARTER_BODY_TYPE = 8;
    private int textType;

    public int getTextType() {
        return this.textType;
    }

    public void setTextType(int type) {
        this.textType = type;
    }

    public RecordContainer getParentRecord() {
        return this.parentRecord;
    }

    public void setParentRecord(RecordContainer record) {
        this.parentRecord = record;
    }

    protected TextHeaderAtom(byte[] source, int start, int len) {
        if (len < 12) {
            len = 12;
            if (source.length - start < 12) {
                throw new RuntimeException("Not enough data to form a TextHeaderAtom (always 12 bytes long) - found " + (source.length - start));
            }
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this.textType = LittleEndian.getInt(source, start + 8);
    }

    public TextHeaderAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort(this._header, 0, 0);
        LittleEndian.putUShort(this._header, 2, (int)_type);
        LittleEndian.putInt(this._header, 4, 4);
        this.textType = 4;
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        TextHeaderAtom.writeLittleEndian(this.textType, out);
    }
}

