/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.ColorTypeProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;

class RGBColorFunction
extends FunctionBase {
    RGBColorFunction() {
    }

    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        float[] cfvals = new float[3];
        int i = 0;
        while (i < 3) {
            Number cval = args[i].getNumber();
            if (cval == null) {
                throw new PropertyException("Argument to rgb() must be a Number");
            }
            float colorVal = cval.floatValue() / 255.0f;
            if ((double)colorVal < 0.0 || (double)colorVal > 255.0) {
                throw new PropertyException("Arguments to rgb() must normalize to the range 0 to 1");
            }
            cfvals[i] = colorVal;
            ++i;
        }
        return new ColorTypeProperty(new ColorType(cfvals[0], cfvals[1], cfvals[2]));
    }

    public PercentBase getPercentBase() {
        return new RGBPercentBase();
    }

    public int nbArgs() {
        return 3;
    }

    static class RGBPercentBase
    implements PercentBase {
        RGBPercentBase() {
        }

        public int getBaseLength() {
            return 0;
        }

        public double getBaseValue() {
            return 255.0;
        }

        public int getDimension() {
            return 0;
        }
    }
}

