/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.util.LinkedList;
import java.util.Vector;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.hslf.record.TextHeaderAtom;
import org.apache.poi.hslf.usermodel.RichTextRun;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.util.StringUtil;

public class TextRun {
    protected TextHeaderAtom _headerAtom;
    protected TextBytesAtom _byteAtom;
    protected TextCharsAtom _charAtom;
    protected StyleTextPropAtom _styleAtom;
    protected boolean _isUnicode;
    protected RichTextRun[] _rtRuns;
    private SlideShow slideShow;
    private Sheet sheet;

    public TextRun(TextHeaderAtom tha, TextCharsAtom tca, StyleTextPropAtom sta) {
        this(tha, null, tca, sta);
    }

    public TextRun(TextHeaderAtom tha, TextBytesAtom tba, StyleTextPropAtom sta) {
        this(tha, tba, null, sta);
    }

    private TextRun(TextHeaderAtom tha, TextBytesAtom tba, TextCharsAtom tca, StyleTextPropAtom sta) {
        this._headerAtom = tha;
        this._styleAtom = sta;
        if (tba != null) {
            this._byteAtom = tba;
            this._isUnicode = false;
        } else {
            this._charAtom = tca;
            this._isUnicode = true;
        }
        String runRawText = this.getText();
        LinkedList pStyles = new LinkedList();
        LinkedList cStyles = new LinkedList();
        if (this._styleAtom != null) {
            this._styleAtom.setParentTextSize(runRawText.length());
            pStyles = this._styleAtom.getParagraphStyles();
            cStyles = this._styleAtom.getCharacterStyles();
        }
        if (pStyles.size() == 0 || cStyles.size() == 0) {
            this._rtRuns = new RichTextRun[1];
            this._rtRuns[0] = new RichTextRun(this, 0, runRawText.length());
        } else {
            Vector<RichTextRun> rtrs = new Vector<RichTextRun>();
            int pos = 0;
            int curP = 0;
            int curC = 0;
            int pLenRemain = -1;
            int cLenRemain = -1;
            while (pos <= runRawText.length() && curP < pStyles.size() && curC < cStyles.size()) {
                TextPropCollection pProps = (TextPropCollection)pStyles.get(curP);
                TextPropCollection cProps = (TextPropCollection)cStyles.get(curC);
                int pLen = pProps.getCharactersCovered();
                int cLen = cProps.getCharactersCovered();
                boolean freshSet = false;
                if (pLenRemain == -1 && cLenRemain == -1) {
                    freshSet = true;
                }
                if (pLenRemain == -1) {
                    pLenRemain = pLen;
                }
                if (cLenRemain == -1) {
                    cLenRemain = cLen;
                }
                int runLen = -1;
                boolean pShared = false;
                boolean cShared = false;
                if (pLen == cLen && freshSet) {
                    runLen = cLen;
                    pShared = false;
                    cShared = false;
                    ++curP;
                    ++curC;
                    pLenRemain = -1;
                    cLenRemain = -1;
                } else if (pLenRemain < pLen) {
                    pShared = true;
                    if (pLenRemain == cLenRemain) {
                        cShared = false;
                        runLen = pLenRemain;
                        ++curP;
                        ++curC;
                        pLenRemain = -1;
                        cLenRemain = -1;
                    } else if (pLenRemain < cLenRemain) {
                        cShared = true;
                        runLen = pLenRemain;
                        ++curP;
                        cLenRemain -= pLenRemain;
                        pLenRemain = -1;
                    } else {
                        cShared = false;
                        runLen = cLenRemain;
                        ++curC;
                        pLenRemain -= cLenRemain;
                        cLenRemain = -1;
                    }
                } else if (cLenRemain < cLen) {
                    cShared = true;
                    if (pLenRemain == cLenRemain) {
                        pShared = false;
                        runLen = cLenRemain;
                        ++curP;
                        ++curC;
                        pLenRemain = -1;
                        cLenRemain = -1;
                    } else if (cLenRemain < pLenRemain) {
                        pShared = true;
                        runLen = cLenRemain;
                        ++curC;
                        pLenRemain -= cLenRemain;
                        cLenRemain = -1;
                    } else {
                        pShared = false;
                        runLen = pLenRemain;
                        ++curP;
                        cLenRemain -= pLenRemain;
                        pLenRemain = -1;
                    }
                } else if (pLenRemain < cLenRemain) {
                    pShared = false;
                    cShared = true;
                    runLen = pLenRemain;
                    ++curP;
                    cLenRemain -= pLenRemain;
                    pLenRemain = -1;
                } else {
                    pShared = true;
                    cShared = false;
                    runLen = cLenRemain;
                    ++curC;
                    pLenRemain -= cLenRemain;
                    cLenRemain = -1;
                }
                int prevPos = pos;
                if ((pos += runLen) > runRawText.length()) {
                    --runLen;
                }
                RichTextRun rtr = new RichTextRun(this, prevPos, runLen, pProps, cProps, pShared, cShared);
                rtrs.add(rtr);
            }
            this._rtRuns = new RichTextRun[rtrs.size()];
            rtrs.copyInto(this._rtRuns);
        }
    }

    private void storeText(String s) {
        if (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        if (this._isUnicode) {
            this._charAtom.setText(s);
        } else {
            boolean hasMultibyte = StringUtil.hasMultibyte(s);
            if (!hasMultibyte) {
                byte[] text = new byte[s.length()];
                StringUtil.putCompressedUnicode(s, text, 0);
                this._byteAtom.setText(text);
            } else {
                this._charAtom = new TextCharsAtom();
                this._charAtom.setText(s);
                RecordContainer parent = this._headerAtom.getParentRecord();
                Record[] cr = parent.getChildRecords();
                for (int i = 0; i < cr.length; ++i) {
                    if (!cr[i].equals(this._byteAtom)) continue;
                    cr[i] = this._charAtom;
                    break;
                }
                this._byteAtom = null;
                this._isUnicode = true;
            }
        }
    }

    public synchronized void changeTextInRichTextRun(RichTextRun run, String s) {
        int runID = -1;
        for (int i = 0; i < this._rtRuns.length; ++i) {
            if (!run.equals(this._rtRuns[i])) continue;
            runID = i;
        }
        if (runID == -1) {
            throw new IllegalArgumentException("Supplied RichTextRun wasn't from this TextRun");
        }
        this.ensureStyleAtomPresent();
        TextPropCollection pCol = run._getRawParagraphStyle();
        TextPropCollection cCol = run._getRawCharacterStyle();
        int newSize = s.length();
        if (runID == this._rtRuns.length - 1) {
            ++newSize;
        }
        if (run._isParagraphStyleShared()) {
            pCol.updateTextSize(pCol.getCharactersCovered() - run.getLength() + s.length());
        } else {
            pCol.updateTextSize(newSize);
        }
        if (run._isCharacterStyleShared()) {
            cCol.updateTextSize(cCol.getCharactersCovered() - run.getLength() + s.length());
        } else {
            cCol.updateTextSize(newSize);
        }
        StringBuffer newText = new StringBuffer();
        for (int i = 0; i < this._rtRuns.length; ++i) {
            int newStartPos = newText.length();
            if (i != runID) {
                newText.append(this._rtRuns[i].getRawText());
            } else {
                newText.append(s);
            }
            if (i <= runID) continue;
            this._rtRuns[i].updateStartPosition(newStartPos);
        }
        this.storeText(newText.toString());
    }

    public synchronized void setText(String s) {
        this.storeText(s);
        RichTextRun fst = this._rtRuns[0];
        for (int i = 0; i < this._rtRuns.length; ++i) {
            this._rtRuns[i] = null;
        }
        this._rtRuns = new RichTextRun[1];
        this._rtRuns[0] = fst;
        if (this._styleAtom != null) {
            LinkedList pStyles = this._styleAtom.getParagraphStyles();
            while (pStyles.size() > 1) {
                pStyles.removeLast();
            }
            LinkedList cStyles = this._styleAtom.getCharacterStyles();
            while (cStyles.size() > 1) {
                cStyles.removeLast();
            }
            this._rtRuns[0].setText(s);
        } else {
            this._rtRuns[0] = new RichTextRun(this, 0, s.length());
        }
    }

    public synchronized void ensureStyleAtomPresent() {
        if (this._styleAtom != null) {
            return;
        }
        this._styleAtom = new StyleTextPropAtom(this.getRawText().length() + 1);
        RecordContainer runAtomsParent = this._headerAtom.getParentRecord();
        RecordAtom addAfter = this._byteAtom;
        if (this._byteAtom == null) {
            addAfter = this._charAtom;
        }
        runAtomsParent.addChildAfter(this._styleAtom, addAfter);
        if (this._rtRuns.length != 1) {
            throw new IllegalStateException("Needed to add StyleTextPropAtom when had many rich text runs");
        }
        this._rtRuns[0].supplyTextProps((TextPropCollection)this._styleAtom.getParagraphStyles().get(0), (TextPropCollection)this._styleAtom.getCharacterStyles().get(0), false, false);
    }

    public String getText() {
        String rawText = this.getRawText();
        String text = rawText.replace('\r', '\n');
        return text;
    }

    public String getRawText() {
        if (this._isUnicode) {
            return this._charAtom.getText();
        }
        return this._byteAtom.getText();
    }

    public RichTextRun[] getRichTextRuns() {
        return this._rtRuns;
    }

    public int getRunType() {
        return this._headerAtom.getTextType();
    }

    public void setRunType(int type) {
        this._headerAtom.setTextType(type);
    }

    public void supplySlideShow(SlideShow ss) {
        this.slideShow = ss;
        if (this._rtRuns != null) {
            for (int i = 0; i < this._rtRuns.length; ++i) {
                this._rtRuns[i].supplySlideShow(this.slideShow);
            }
        }
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public Sheet getSheet() {
        return this.sheet;
    }
}

