/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.util.SqljTrace;

public class ProfileGroup {
    private static boolean cacheProfiles = false;
    private static Hashtable globalProfileCache = new Hashtable();
    Hashtable m_profileKeys = new Hashtable();
    Vector m_profiles = new Vector();
    Vector m_connGroups = new Vector();

    public ProfileGroup() {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("Constructing Profile Group :" + this);
        }
    }

    public synchronized void freeContextProfileCache() {
        this.m_profileKeys.clear();
        this.m_profiles.removeAllElements();
    }

    public static synchronized void freeGlobalProfileCache() {
        globalProfileCache.clear();
    }

    public static synchronized void enableGlobalProfileCache() {
        cacheProfiles = true;
    }

    public static synchronized void disableGlobalProfileCache() {
        cacheProfiles = false;
        ProfileGroup.freeGlobalProfileCache();
    }

    public synchronized Object getProfileKey(Loader loader, String string) throws SQLException {
        Key key = (Key)this.m_profileKeys.get(string);
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ProfileGroup.getProfileKey() is called for profile " + string);
            if (key != null) {
                SqljTrace.printMessage("ProfileGroup.getProfileKey() is called. Profile Key is : " + key.index);
            } else {
                SqljTrace.printMessage("ProfileGroup.getProfileKey() is called. Profile Key is : NULL");
            }
        }
        if (key != null && cacheProfiles) {
            return key;
        }
        Profile profile = null;
        if (cacheProfiles) {
            profile = (Profile)globalProfileCache.get(string);
        }
        if (profile == null) {
            if (SqljTrace.isContextTraceOn()) {
                SqljTrace.printMessage("LOADING PROFILE : " + string);
            }
            try {
                profile = Profile.instantiate(loader, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                RuntimeRefErrors.raise_PROFILE_NOT_FOUND(string, classNotFoundException);
            }
            catch (IOException iOException) {
                RuntimeRefErrors.raise_PROFILE_NOT_FOUND(string, iOException);
            }
            if (cacheProfiles) {
                globalProfileCache.put(string, profile);
            }
        } else if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ProfileGroup.getProfileKey() is called for profile " + string + " - Profile is already loaded");
        }
        if (key == null) {
            key = new Key(this.m_profiles.size());
            this.m_profileKeys.put(string, key);
            this.m_profiles.addElement(profile);
            Enumeration enumeration = this.m_connGroups.elements();
            while (enumeration.hasMoreElements()) {
                ((ConnectedGroup)enumeration.nextElement()).addProfile();
            }
        } else {
            int n2 = key.index;
            this.m_profiles.set(n2, profile);
            Enumeration enumeration = this.m_connGroups.elements();
            while (enumeration.hasMoreElements()) {
                ((ConnectedGroup)enumeration.nextElement()).closeProfile(n2);
            }
        }
        return key;
    }

    public Profile getProfile(Object object) {
        if (object == null || !(object instanceof Key)) {
            throw new IllegalArgumentException(object + "");
        }
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ProfileGroup.getProfile() is  called for Key " + ((Key)object).index);
        }
        return (Profile)this.m_profiles.elementAt(((Key)object).index);
    }

    public synchronized ConnectedGroup addConnection(Connection connection) {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ProfileGroup.addConnection() is called :" + this + " for Connection :" + connection);
        }
        ConnectedGroup connectedGroup = new ConnectedGroup(connection);
        this.m_connGroups.addElement(connectedGroup);
        return connectedGroup;
    }

    private synchronized void removeConnection(ConnectedGroup connectedGroup) {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ProfileGroup.removeConnection() called for connection " + connectedGroup.m_conn);
        }
        this.m_connGroups.removeElement(connectedGroup);
    }

    class ConnectedGroup {
        private Connection m_conn;
        private Vector m_connProfiles = new Vector();

        ConnectedGroup(Connection connection) {
            if (SqljTrace.isContextTraceOn()) {
                SqljTrace.printMessage("ConnectedGroup constructor for connection :" + connection + " is called");
            }
            this.m_conn = connection;
            int n2 = ProfileGroup.this.m_profiles.size();
            while (n2 > 0) {
                this.addProfile();
                --n2;
            }
        }

        public void closeProfile(int n2) throws SQLException {
            ConnectedProfile connectedProfile;
            if (SqljTrace.isContextTraceOn()) {
                SqljTrace.printMessage("ConnectedGroup.closeProfile() is called for Connection " + this.m_conn);
                SqljTrace.printMessage("ConnectedGroup.closeProfile() is called for profile Key " + n2);
            }
            if ((connectedProfile = (ConnectedProfile)this.m_connProfiles.set(n2, null)) != null) {
                connectedProfile.close();
            }
        }

        public void addProfile() {
            if (SqljTrace.isContextTraceOn()) {
                SqljTrace.printMessage("ConnectedGroup.addProfile() is called " + this);
            }
            this.m_connProfiles.addElement(null);
        }

        public ConnectedProfile getProfile(Object object) throws SQLException {
            if (object == null || !(object instanceof Key)) {
                throw new IllegalArgumentException(object + "");
            }
            int n2 = ((Key)object).index;
            ConnectedProfile connectedProfile = (ConnectedProfile)this.m_connProfiles.elementAt(n2);
            if (connectedProfile == null) {
                if (SqljTrace.isContextTraceOn()) {
                    SqljTrace.printMessage("ConnectedGroup.getProfile() for key " + n2 + " is called - Creating Connected Profile ");
                }
                Profile profile = (Profile)ProfileGroup.this.m_profiles.elementAt(n2);
                connectedProfile = profile.getConnectedProfile(this.m_conn);
                this.m_connProfiles.setElementAt(connectedProfile, n2);
            } else if (SqljTrace.isContextTraceOn()) {
                SqljTrace.printMessage("ConnectedGroup.getProfile() for key " + n2 + " is called - Connected Profile already created");
            }
            return connectedProfile;
        }

        public void close() throws SQLException {
            ProfileGroup.this.removeConnection(this);
            Enumeration enumeration = this.m_connProfiles.elements();
            while (enumeration.hasMoreElements()) {
                ConnectedProfile connectedProfile = (ConnectedProfile)enumeration.nextElement();
                if (connectedProfile == null) continue;
                connectedProfile.close();
            }
            if (SqljTrace.isContextTraceOn()) {
                SqljTrace.printMessage("ConnectedGroup.close() is called : " + this + " for connection :" + this.m_conn);
            }
        }
    }

    class Key {
        int index;

        Key(int n2) {
            this.index = n2;
        }
    }
}

