/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import org.seasar.extension.jdbc.gen.desc.AssociationDesc;
import org.seasar.extension.jdbc.gen.desc.AssociationType;
import org.seasar.extension.jdbc.gen.desc.AttributeDesc;
import org.seasar.extension.jdbc.gen.desc.EntityDesc;
import org.seasar.extension.jdbc.gen.desc.EntitySetDesc;
import org.seasar.extension.jdbc.gen.internal.desc.PluralFormDictinary;
import org.seasar.extension.jdbc.gen.meta.DbForeignKeyMeta;
import org.seasar.extension.jdbc.gen.meta.DbTableMeta;
import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.util.StringUtil;

public class AssociationResolver {
    protected static String TO_MANY_ASSOCIATION_NAME_SUFFIX = "List";
    protected EntitySetDesc entitySetDesc;
    protected PluralFormDictinary pluralFormDictinary;
    protected PersistenceConvention persistenceConvention;

    public AssociationResolver(EntitySetDesc entitySetDesc, PluralFormDictinary pluralFormDictinary, PersistenceConvention persistenceConvention) {
        if (entitySetDesc == null) {
            throw new NullPointerException("entitySetDesc");
        }
        if (pluralFormDictinary == null) {
            throw new NullPointerException("pluralFormDictinary");
        }
        if (persistenceConvention == null) {
            throw new NullPointerException("persistenceConvention");
        }
        this.entitySetDesc = entitySetDesc;
        this.pluralFormDictinary = pluralFormDictinary;
        this.persistenceConvention = persistenceConvention;
    }

    public void resolve(DbTableMeta tableMeta, DbForeignKeyMeta fkMeta) {
        EntityDesc ownerEntityDesc = this.entitySetDesc.getEntityDesc(tableMeta.getFullTableName());
        if (ownerEntityDesc == null) {
            return;
        }
        EntityDesc inverseEntityDesc = this.entitySetDesc.getEntityDesc(fkMeta.getPrimaryKeyFullTableName());
        if (inverseEntityDesc == null) {
            return;
        }
        AssociationDesc ownerAssociationDesc = this.doOwnerAssociationDesc(fkMeta, ownerEntityDesc, inverseEntityDesc);
        this.doInverseAssociationDesc(fkMeta, ownerEntityDesc, inverseEntityDesc, ownerAssociationDesc.getName());
    }

    protected AssociationDesc doOwnerAssociationDesc(DbForeignKeyMeta fkMeta, EntityDesc ownerEntityDesc, EntityDesc inverseEntityDesc) {
        AssociationDesc associationDesc = new AssociationDesc();
        associationDesc.setReferencedCatalogName(fkMeta.getPrimaryKeyCatalogName());
        associationDesc.setReferencedSchemaName(fkMeta.getPrimaryKeySchemaName());
        associationDesc.setReferencedTableName(fkMeta.getPrimaryKeyTableName());
        String name = this.getOwnerAssociationName(fkMeta, ownerEntityDesc, inverseEntityDesc);
        associationDesc.setName(name);
        this.adjustAttributeNames(fkMeta, ownerEntityDesc, name);
        if (fkMeta.isUnique()) {
            associationDesc.setAssociationType(AssociationType.ONE_TO_ONE);
        } else {
            associationDesc.setAssociationType(AssociationType.MANY_TO_ONE);
        }
        for (String referencedColumnName : fkMeta.getPrimaryKeyColumnNameList()) {
            associationDesc.addReferencedColumnName(referencedColumnName);
        }
        for (String columnName : fkMeta.getForeignKeyColumnNameList()) {
            associationDesc.addColumnName(columnName);
        }
        associationDesc.setReferencedEntityDesc(inverseEntityDesc);
        ownerEntityDesc.addAssociationDesc(associationDesc);
        return associationDesc;
    }

    protected void adjustAttributeNames(DbForeignKeyMeta fkMeta, EntityDesc entityDesc, String associationName) {
        if (fkMeta.isComposite()) {
            return;
        }
        for (AttributeDesc attributeDesc : entityDesc.getAttributeDescList()) {
            if (!associationName.equalsIgnoreCase(attributeDesc.getName())) continue;
            String pkColumnName = fkMeta.getPrimaryKeyColumnNameList().get(0);
            String pkPropertyName = this.persistenceConvention.fromColumnNameToPropertyName(pkColumnName);
            String candidateName = attributeDesc.getName() + StringUtil.capitalize((String)pkPropertyName);
            String newName = this.toUniqueAttributeName(entityDesc, candidateName);
            attributeDesc.setName(newName);
        }
    }

    protected String toUniqueAttributeName(EntityDesc entityDesc, String candidateName) {
        if (entityDesc.hasAttributeDesc(candidateName)) {
            int i = 2;
            while (true) {
                if (!entityDesc.hasAttributeDesc(candidateName + i)) {
                    return candidateName + i;
                }
                ++i;
            }
        }
        return candidateName;
    }

    protected void doInverseAssociationDesc(DbForeignKeyMeta fkMeta, EntityDesc ownerEntityDesc, EntityDesc inverseEntityDesc, String mappedBy) {
        AssociationDesc inverseAssociationDesc = new AssociationDesc();
        if (fkMeta.isUnique()) {
            String name = this.getInverseAssociationName(inverseEntityDesc, ownerEntityDesc, false);
            inverseAssociationDesc.setName(name);
            inverseAssociationDesc.setAssociationType(AssociationType.ONE_TO_ONE);
        } else {
            String name = this.getInverseAssociationName(inverseEntityDesc, ownerEntityDesc, true);
            inverseAssociationDesc.setName(name);
            inverseAssociationDesc.setAssociationType(AssociationType.ONE_TO_MANY);
        }
        inverseAssociationDesc.setMappedBy(mappedBy);
        inverseAssociationDesc.setReferencedEntityDesc(ownerEntityDesc);
        inverseEntityDesc.addAssociationDesc(inverseAssociationDesc);
    }

    protected String getOwnerAssociationName(DbForeignKeyMeta fkMeta, EntityDesc ownerEntityDesc, EntityDesc inverseEntityDesc) {
        String pkColumnName;
        String fkColumnName;
        String associationName = StringUtil.decapitalize((String)inverseEntityDesc.getName());
        if (!fkMeta.isComposite() && StringUtil.endsWithIgnoreCase((String)(fkColumnName = fkMeta.getForeignKeyColumnNameList().get(0)), (String)(pkColumnName = fkMeta.getPrimaryKeyColumnNameList().get(0))) && fkColumnName.length() > pkColumnName.length()) {
            String name = fkColumnName.substring(0, fkColumnName.length() - pkColumnName.length());
            name = StringUtil.trimSuffix((String)name, (String)"_");
            name = StringUtil.camelize((String)name);
            associationName = StringUtil.startsWithIgnoreCase((String)pkColumnName, (String)inverseEntityDesc.getTableName()) ? StringUtil.decapitalize((String)name) + inverseEntityDesc.getName() : StringUtil.decapitalize((String)name);
        }
        return this.toUniqueAssociationName(ownerEntityDesc, associationName);
    }

    protected String getInverseAssociationName(EntityDesc inverseEntityDesc, EntityDesc ownerEntityDesc, boolean oneToMany) {
        String associationName = StringUtil.decapitalize((String)ownerEntityDesc.getName());
        if (oneToMany) {
            associationName = this.pluralizeName(associationName);
        }
        return this.toUniqueAssociationName(inverseEntityDesc, associationName);
    }

    protected String toUniqueAssociationName(EntityDesc entityDesc, String candidateName) {
        if (entityDesc.hasAssociationDesc(candidateName)) {
            int i = 2;
            while (true) {
                if (!entityDesc.hasAssociationDesc(candidateName + i)) {
                    return candidateName + i;
                }
                ++i;
            }
        }
        return candidateName;
    }

    protected String pluralizeName(String name) {
        String pluralizedName = this.pluralFormDictinary.lookup(name);
        if (pluralizedName != null) {
            return pluralizedName;
        }
        return name + TO_MANY_ASSOCIATION_NAME_SUFFIX;
    }
}

