/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import de.regnis.q.sequence.line.diff.QDiffGenerator;
import de.regnis.q.sequence.line.diff.QDiffManager;
import de.regnis.q.sequence.line.diff.QDiffUniGenerator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNReturnValueCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNDiffGenerator
implements ISVNDiffGenerator {
    protected static final byte[] PROPERTIES_SEPARATOR = "___________________________________________________________________".getBytes();
    protected static final byte[] HEADER_SEPARATOR = "===================================================================".getBytes();
    protected static final String WC_REVISION_LABEL = "(working copy)";
    protected static final InputStream EMPTY_FILE_IS = SVNFileUtil.DUMMY_IN;
    private boolean myIsForcedBinaryDiff;
    private String myAnchorPath1 = "";
    private String myAnchorPath2 = "";
    private ISVNOptions myOptions;
    private String myEncoding;
    private byte[] myEOL;
    private boolean myIsDiffDeleted = true;
    private boolean myIsDiffAdded;
    private boolean myIsDiffCopied;
    private File myBasePath;
    private boolean myIsDiffUnversioned;
    private SVNDiffOptions myDiffOptions;
    private Collection myRawDiffOptions;
    private String myDiffCommand;
    private boolean myIsUseAbsolutePaths;

    public void init(String anchorPath1, String anchorPath2) {
        this.myAnchorPath1 = anchorPath1.replace(File.separatorChar, '/');
        this.myAnchorPath2 = anchorPath2.replace(File.separatorChar, '/');
    }

    public void setDiffOptions(SVNDiffOptions options) {
        this.myDiffOptions = options;
    }

    public void setRawDiffOptions(Collection options) {
        this.myRawDiffOptions = options;
    }

    public void setOptions(ISVNOptions options) {
        this.myOptions = options;
    }

    public void setExternalDiffCommand(String command) {
        this.myDiffCommand = command;
    }

    public void setBasePath(File basePath) {
        this.myBasePath = basePath;
    }

    public void setFallbackToAbsolutePath(boolean fallback) {
        this.myIsUseAbsolutePaths = fallback;
    }

    public void setDiffDeleted(boolean isDiffDeleted) {
        this.myIsDiffDeleted = isDiffDeleted;
    }

    public boolean isDiffDeleted() {
        return this.myIsDiffDeleted;
    }

    public void setDiffAdded(boolean isDiffAdded) {
        this.myIsDiffAdded = isDiffAdded;
    }

    public boolean isDiffAdded() {
        return this.myIsDiffAdded;
    }

    public void setDiffCopied(boolean isDiffCopied) {
        this.myIsDiffCopied = isDiffCopied;
    }

    public boolean isDiffCopied() {
        return this.myIsDiffCopied;
    }

    public SVNDiffOptions getDiffOptions() {
        if (this.myDiffOptions == null) {
            this.myDiffOptions = new SVNDiffOptions();
        }
        return this.myDiffOptions;
    }

    protected String getDisplayPath(String path) throws SVNException {
        if (this.myBasePath == null) {
            return path;
        }
        if (path == null) {
            path = "";
        }
        if (SVNPathUtil.isURL(path)) {
            return path;
        }
        String basePath = this.myBasePath.getAbsolutePath().replace(File.separatorChar, '/');
        if ((path = new File(path).getAbsolutePath().replace(File.separatorChar, '/')).equals(basePath)) {
            return ".";
        }
        String relativePath = SVNPathUtil.getPathAsChild(basePath, path);
        if (relativePath == null) {
            if (this.myIsUseAbsolutePaths) {
                return path;
            }
            this.createBadRelativePathError(path);
        }
        if (relativePath.startsWith("./")) {
            relativePath = relativePath.substring("./".length());
        }
        return relativePath;
    }

    public void setForcedBinaryDiff(boolean forced) {
        this.myIsForcedBinaryDiff = forced;
    }

    public boolean isForcedBinaryDiff() {
        return this.myIsForcedBinaryDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayPropDiff(String path, SVNProperties baseProps, SVNProperties diff, OutputStream result) throws SVNException {
        baseProps = baseProps != null ? baseProps : new SVNProperties();
        diff = diff != null ? diff : new SVNProperties();
        Iterator changedPropNames = diff.nameSet().iterator();
        while (changedPropNames.hasNext()) {
            String name = (String)changedPropNames.next();
            SVNPropertyValue originalValue = baseProps.getSVNPropertyValue(name);
            SVNPropertyValue newValue = diff.getSVNPropertyValue(name);
            if ((originalValue == null || !originalValue.equals(newValue)) && (originalValue != null || newValue != null)) continue;
            changedPropNames.remove();
        }
        if (diff.isEmpty()) {
            return;
        }
        path = this.getDisplayPath(path);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        diff = new SVNProperties(diff);
        try {
            bos.write(this.getEOL());
            bos.write(("Property changes on: " + (this.useLocalFileSeparatorChar() ? path.replace('/', File.separatorChar) : path)).getBytes(this.getEncoding()));
            bos.write(this.getEOL());
            bos.write(PROPERTIES_SEPARATOR);
            bos.write(this.getEOL());
            for (String name : diff.nameSet()) {
                SVNPropertyValue originalValue = baseProps != null ? baseProps.getSVNPropertyValue(name) : null;
                SVNPropertyValue newValue = diff.getSVNPropertyValue(name);
                String headerFormat = null;
                headerFormat = originalValue == null ? "Added: " : (newValue == null ? "Deleted: " : "Modified: ");
                bos.write((headerFormat + name).getBytes(this.getEncoding()));
                bos.write(this.getEOL());
                if ("svn:mergeinfo".equals(name)) {
                    this.displayMergeInfoDiff(bos, originalValue == null ? null : originalValue.getString(), newValue == null ? null : newValue.getString());
                    continue;
                }
                if (originalValue != null) {
                    bos.write("   - ".getBytes(this.getEncoding()));
                    bos.write(this.getPropertyAsBytes(originalValue, this.getEncoding()));
                    bos.write(this.getEOL());
                }
                if (newValue == null) continue;
                bos.write("   + ".getBytes(this.getEncoding()));
                bos.write(this.getPropertyAsBytes(newValue, this.getEncoding()));
                bos.write(this.getEOL());
            }
            bos.write(this.getEOL());
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
        }
        finally {
            try {
                bos.close();
                bos.writeTo(result);
            }
            catch (IOException e) {}
        }
    }

    private byte[] getPropertyAsBytes(SVNPropertyValue value, String encoding) {
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            try {
                return value.getString().getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                return value.getString().getBytes();
            }
        }
        return value.getBytes();
    }

    protected File getBasePath() {
        return this.myBasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFileDiff(String path, File file1, File file2, String rev1, String rev2, String mimeType1, String mimeType2, OutputStream result) throws SVNException {
        String header;
        SVNErrorMessage err;
        int i;
        path = this.getDisplayPath(path);
        for (i = 0; i < this.myAnchorPath1.length() && i < this.myAnchorPath2.length() && this.myAnchorPath1.charAt(i) == this.myAnchorPath2.charAt(i); ++i) {
        }
        if (i < this.myAnchorPath1.length() || i < this.myAnchorPath2.length()) {
            if (i == this.myAnchorPath1.length()) {
                i = this.myAnchorPath1.length() - 1;
            }
            while (i > 0 && this.myAnchorPath1.charAt(i) != '/') {
                --i;
            }
        }
        String p1 = this.myAnchorPath1.substring(i);
        String p2 = this.myAnchorPath2.substring(i);
        p1 = p1.length() == 0 ? path : (p1.charAt(0) == '/' ? path + "\t(..." + p1 + ")" : path + "\t(.../" + p1 + ")");
        p2 = p2.length() == 0 ? path : (p2.charAt(0) == '/' ? path + "\t(..." + p2 + ")" : path + "\t(.../" + p2 + ")");
        String label1 = this.getLabel(p1, rev1);
        String label2 = this.getLabel(p2, rev2);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (this.displayHeader(bos, path, file2 == null)) {
                bos.close();
                bos.writeTo(result);
                return;
            }
            if (this.isHeaderForced(file1, file2)) {
                bos.writeTo(result);
                bos.reset();
            }
        }
        catch (IOException e) {
            try {
                bos.close();
                bos.writeTo(result);
            }
            catch (IOException inner) {
                // empty catch block
            }
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
        }
        if (!this.isForcedBinaryDiff() && (SVNProperty.isBinaryMimeType(mimeType1) || SVNProperty.isBinaryMimeType(mimeType2))) {
            try {
                this.displayBinary(bos, mimeType1, mimeType2);
            }
            catch (IOException e) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
            }
            finally {
                try {
                    bos.close();
                    bos.writeTo(result);
                }
                catch (IOException e) {}
            }
            return;
        }
        if (file1 == file2 && file1 == null) {
            try {
                bos.close();
                bos.writeTo(result);
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        final String diffCommand = this.getExternalDiffCommand();
        if (diffCommand != null) {
            try {
                bos.close();
                bos.writeTo(result);
            }
            catch (IOException e) {
                // empty catch block
            }
            LinkedList<String> args = new LinkedList<String>();
            File diffCommandFile = new File(diffCommand);
            args.add(diffCommandFile.getAbsolutePath().replace(File.separatorChar, '/'));
            if (this.myRawDiffOptions != null) {
                args.addAll(this.myRawDiffOptions);
            } else {
                Collection diffOptions = this.getDiffOptions().toOptionsCollection();
                args.addAll(diffOptions);
                args.add("-u");
            }
            if (label1 != null) {
                args.add("-L");
                args.add(label1);
            }
            if (label2 != null) {
                args.add("-L");
                args.add(label2);
            }
            boolean tmpFile1 = false;
            boolean tmpFile2 = false;
            if (file1 == null) {
                file1 = SVNFileUtil.createTempFile("svn.", ".tmp");
                tmpFile1 = true;
            }
            if (file2 == null) {
                file2 = SVNFileUtil.createTempFile("svn.", ".tmp");
                tmpFile2 = true;
            }
            String currentDir = new File("").getAbsolutePath().replace(File.separatorChar, '/');
            String file1Path = file1.getAbsolutePath().replace(File.separatorChar, '/');
            String file2Path = file2.getAbsolutePath().replace(File.separatorChar, '/');
            if (file1Path.startsWith(currentDir)) {
                String string = file1Path = (file1Path = file1Path.substring(currentDir.length())).startsWith("/") ? file1Path.substring(1) : file1Path;
            }
            if (file2Path.startsWith(currentDir)) {
                file2Path = (file2Path = file2Path.substring(currentDir.length())).startsWith("/") ? file2Path.substring(1) : file2Path;
            }
            args.add(file1Path);
            args.add(file2Path);
            try {
                final OutputStreamWriter writer = new OutputStreamWriter(result, this.getEncoding());
                SVNFileUtil.execCommand(args.toArray(new String[args.size()]), true, new ISVNReturnValueCallback(){

                    public void handleReturnValue(int returnValue) throws SVNException {
                        if (returnValue != 0 && returnValue != 1) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "''{0}'' returned {1}", new Object[]{diffCommand, String.valueOf(returnValue)});
                            SVNErrorManager.error(err, SVNLogType.DEFAULT);
                        }
                    }

                    public void handleChar(char ch) throws SVNException {
                        try {
                            writer.write(ch);
                        }
                        catch (IOException ioe) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getMessage());
                            SVNErrorManager.error(err, ioe, SVNLogType.DEFAULT);
                        }
                    }

                    public boolean isHandleProgramOutput() {
                        return true;
                    }
                });
                ((Writer)writer).flush();
            }
            catch (IOException ioe) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getMessage());
                SVNErrorManager.error(err2, ioe, SVNLogType.DEFAULT);
            }
            finally {
                try {
                    if (tmpFile1) {
                        SVNFileUtil.deleteFile(file1);
                    }
                    if (tmpFile2) {
                        SVNFileUtil.deleteFile(file2);
                    }
                }
                catch (SVNException e) {}
            }
            return;
        }
        try {
            this.displayHeaderFields(bos, label1, label2);
        }
        catch (IOException e) {
            try {
                bos.close();
                bos.writeTo(result);
            }
            catch (IOException inner) {
                // empty catch block
            }
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err3, e, SVNLogType.DEFAULT);
        }
        try {
            bos.close();
            header = bos.toString();
        }
        catch (IOException inner) {
            header = "";
        }
        RandomAccessFile is1 = null;
        RandomAccessFile is2 = null;
        try {
            is1 = file1 == null ? null : SVNFileUtil.openRAFileForReading(file1);
            is2 = file2 == null ? null : SVNFileUtil.openRAFileForReading(file2);
            QDiffUniGenerator.setup();
            SVNHashMap properties = new SVNHashMap();
            properties.put("ignore-eol-style", this.getDiffOptions().isIgnoreEOLStyle());
            if (this.getDiffOptions().isIgnoreAllWhitespace()) {
                properties.put("ignore-space", "all-space");
            } else if (this.getDiffOptions().isIgnoreAmountOfWhitespace()) {
                properties.put("ignore-space", "space-change");
            }
            QDiffUniGenerator generator = new QDiffUniGenerator(properties, header);
            OutputStreamWriter writer = new OutputStreamWriter(result, this.getEncoding());
            QDiffManager.generateTextDiff(is1, is2, this.getEncoding(), (Writer)writer, (QDiffGenerator)generator);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
                SVNErrorManager.error(err4, e, SVNLogType.DEFAULT);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(is1);
                SVNFileUtil.closeFile(is2);
                throw throwable;
            }
            SVNFileUtil.closeFile(is1);
            SVNFileUtil.closeFile(is2);
        }
        SVNFileUtil.closeFile(is1);
        SVNFileUtil.closeFile(is2);
    }

    public void setEncoding(String encoding) {
        this.myEncoding = encoding;
    }

    public String getEncoding() {
        if (this.hasEncoding()) {
            return this.myEncoding;
        }
        return this.getOptions().getNativeCharset();
    }

    public boolean hasEncoding() {
        return this.myEncoding != null;
    }

    public void setEOL(byte[] eol) {
        this.myEOL = eol;
    }

    public byte[] getEOL() {
        if (this.myEOL == null) {
            this.myEOL = this.getOptions().getNativeEOL();
        }
        return this.myEOL;
    }

    public File createTempDirectory() throws SVNException {
        return SVNFileUtil.createTempDirectory("diff");
    }

    public boolean isDiffUnversioned() {
        return this.myIsDiffUnversioned;
    }

    public void setDiffUnversioned(boolean diffUnversioned) {
        this.myIsDiffUnversioned = diffUnversioned;
    }

    public void displayDeletedDirectory(String path, String rev1, String rev2) throws SVNException {
    }

    public void displayAddedDirectory(String path, String rev1, String rev2) throws SVNException {
    }

    protected String getExternalDiffCommand() {
        if (this.myDiffCommand != null) {
            return this.myDiffCommand;
        }
        if (this.myOptions instanceof DefaultSVNOptions) {
            return ((DefaultSVNOptions)this.myOptions).getDiffCommand();
        }
        return null;
    }

    protected ISVNOptions getOptions() {
        if (this.myOptions == null) {
            this.myOptions = new DefaultSVNOptions();
        }
        return this.myOptions;
    }

    protected void displayBinary(OutputStream os, String mimeType1, String mimeType2) throws IOException {
        os.write("Cannot display: file marked as a binary type.".getBytes(this.getEncoding()));
        os.write(this.getEOL());
        if (SVNProperty.isBinaryMimeType(mimeType1) && !SVNProperty.isBinaryMimeType(mimeType2)) {
            os.write("svn:mime-type = ".getBytes(this.getEncoding()));
            os.write(mimeType1.getBytes(this.getEncoding()));
            os.write(this.getEOL());
        } else if (!SVNProperty.isBinaryMimeType(mimeType1) && SVNProperty.isBinaryMimeType(mimeType2)) {
            os.write("svn:mime-type = ".getBytes(this.getEncoding()));
            os.write(mimeType2.getBytes(this.getEncoding()));
            os.write(this.getEOL());
        } else if (SVNProperty.isBinaryMimeType(mimeType1) && SVNProperty.isBinaryMimeType(mimeType2)) {
            if (mimeType1.equals(mimeType2)) {
                os.write("svn:mime-type = ".getBytes(this.getEncoding()));
                os.write(mimeType2.getBytes(this.getEncoding()));
                os.write(this.getEOL());
            } else {
                os.write("svn:mime-type = (".getBytes(this.getEncoding()));
                os.write(mimeType1.getBytes(this.getEncoding()));
                os.write(", ".getBytes(this.getEncoding()));
                os.write(mimeType2.getBytes(this.getEncoding()));
                os.write(")".getBytes(this.getEncoding()));
                os.write(this.getEOL());
            }
        }
    }

    protected boolean displayHeader(OutputStream os, String path, boolean deleted) throws IOException {
        if (deleted && !this.isDiffDeleted()) {
            os.write("Index: ".getBytes(this.getEncoding()));
            os.write(path.getBytes(this.getEncoding()));
            os.write(" (deleted)".getBytes(this.getEncoding()));
            os.write(this.getEOL());
            os.write(HEADER_SEPARATOR);
            os.write(this.getEOL());
            return true;
        }
        os.write("Index: ".getBytes(this.getEncoding()));
        os.write(path.getBytes(this.getEncoding()));
        os.write(this.getEOL());
        os.write(HEADER_SEPARATOR);
        os.write(this.getEOL());
        return false;
    }

    protected void displayHeaderFields(OutputStream os, String label1, String label2) throws IOException {
        os.write("--- ".getBytes(this.getEncoding()));
        os.write(label1.getBytes(this.getEncoding()));
        os.write(this.getEOL());
        os.write("+++ ".getBytes(this.getEncoding()));
        os.write(label2.getBytes(this.getEncoding()));
        os.write(this.getEOL());
    }

    protected boolean isHeaderForced(File file1, File file2) {
        return file1 == null && file2 != null;
    }

    protected boolean useLocalFileSeparatorChar() {
        return true;
    }

    protected String getLabel(String path, String revToken) {
        revToken = revToken == null ? WC_REVISION_LABEL : revToken;
        return path + "\t" + revToken;
    }

    private void displayMergeInfoDiff(ByteArrayOutputStream baos, String oldValue, String newValue) throws SVNException, IOException {
        SVNMergeRangeList rangeList;
        Map oldMergeInfo = null;
        Map newMergeInfo = null;
        if (oldValue != null) {
            oldMergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(oldValue), null);
        }
        if (newValue != null) {
            newMergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(newValue), null);
        }
        TreeMap deleted = new TreeMap();
        TreeMap added = new TreeMap();
        SVNMergeInfoUtil.diffMergeInfo(deleted, added, oldMergeInfo, newMergeInfo, true);
        for (String path : deleted.keySet()) {
            rangeList = (SVNMergeRangeList)deleted.get(path);
            baos.write(("   Reverse-merged " + path + ":r").getBytes(this.getEncoding()));
            baos.write(rangeList.toString().getBytes(this.getEncoding()));
            baos.write(this.getEOL());
        }
        for (String path : added.keySet()) {
            rangeList = (SVNMergeRangeList)added.get(path);
            baos.write(("   Merged " + path + ":r").getBytes(this.getEncoding()));
            baos.write(rangeList.toString().getBytes(this.getEncoding()));
            baos.write(this.getEOL());
        }
    }

    private void createBadRelativePathError(String path) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_RELATIVE_PATH, "Path ''{0}'' must be an immediate child of the directory ''{1}''", new Object[]{path, this.myBasePath});
        SVNErrorManager.error(err, SVNLogType.DEFAULT);
    }
}

