/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNStatusUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class SVNStatusEditor {
    private SVNWCAccess myWCAccess;
    private SVNAdminAreaInfo myAdminInfo;
    private boolean myIsReportAll;
    private boolean myIsNoIgnore;
    private SVNDepth myDepth;
    private ISVNStatusHandler myStatusHandler;
    private Map myExternalsMap;
    private Collection myGlobalIgnores;
    private SVNURL myRepositoryRoot;
    private Map myRepositoryLocks;
    private long myTargetRevision;

    public SVNStatusEditor(ISVNOptions options, SVNWCAccess wcAccess, SVNAdminAreaInfo info, boolean noIgnore, boolean reportAll, SVNDepth depth, ISVNStatusHandler handler) {
        this.myWCAccess = wcAccess;
        this.myAdminInfo = info;
        this.myIsNoIgnore = noIgnore;
        this.myIsReportAll = reportAll;
        this.myDepth = depth;
        this.myStatusHandler = handler;
        this.myExternalsMap = new SVNHashMap();
        this.myGlobalIgnores = SVNStatusEditor.getGlobalIgnores(options);
        this.myTargetRevision = -1L;
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void targetRevision(long revision) {
        this.myTargetRevision = revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo closeEdit() throws SVNException {
        try {
            if (this.hasTarget()) {
                File path = this.myAdminInfo.getAnchor().getFile(this.myAdminInfo.getTargetName());
                SVNFileType type = SVNFileType.getType(path);
                if (type == SVNFileType.DIRECTORY) {
                    SVNEntry entry = this.myWCAccess.getEntry(path, false);
                    if (entry == null) {
                        this.getDirStatus(null, this.myAdminInfo.getAnchor(), this.myAdminInfo.getTargetName(), SVNDepth.EMPTY, this.myIsReportAll, true, null, true, this.myStatusHandler);
                    } else {
                        SVNAdminArea target = this.myWCAccess.retrieve(path);
                        this.getDirStatus(null, target, null, this.myDepth, this.myIsReportAll, this.myIsNoIgnore, null, false, this.myStatusHandler);
                    }
                } else {
                    this.getDirStatus(null, this.myAdminInfo.getAnchor(), this.myAdminInfo.getTargetName(), SVNDepth.EMPTY, this.myIsReportAll, true, null, true, this.myStatusHandler);
                }
            } else {
                this.getDirStatus(null, this.myAdminInfo.getAnchor(), null, this.myDepth, this.myIsReportAll, this.myIsNoIgnore, null, false, this.myStatusHandler);
            }
        }
        finally {
            this.cleanup();
        }
        return null;
    }

    public void setRepositoryInfo(SVNURL root, Map repositoryLocks) {
        this.myRepositoryRoot = root;
        this.myRepositoryLocks = repositoryLocks;
    }

    protected void getDirStatus(SVNEntry parentEntry, SVNAdminArea dir, String entryName, SVNDepth depth, boolean getAll, boolean noIgnore, Collection ignorePatterns, boolean skipThisDir, ISVNStatusHandler handler) throws SVNException {
        SVNStatus status;
        this.myWCAccess.checkCancelled();
        depth = depth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : depth;
        TreeMap childrenFiles = SVNStatusEditor.getChildrenFiles(dir.getRoot());
        SVNEntry dirEntry = this.myWCAccess.getEntry(dir.getRoot(), false);
        String externals = dir.getProperties(dir.getThisDirName()).getStringPropertyValue("svn:externals");
        if (externals != null) {
            String path = dir.getRelativePath(this.myAdminInfo.getAnchor());
            this.myAdminInfo.addExternal(path, externals, externals);
            this.myAdminInfo.addDepth(path, dirEntry.getDepth());
            SVNExternal[] externalsInfo = SVNExternal.parseExternals(dir.getRelativePath(this.myAdminInfo.getAnchor()), externals);
            for (int i = 0; i < externalsInfo.length; ++i) {
                SVNExternal external = externalsInfo[i];
                this.myExternalsMap.put(SVNPathUtil.append(path, external.getPath()), external);
            }
        }
        if (entryName != null) {
            File file = (File)childrenFiles.get(entryName);
            SVNEntry entry = dir.getEntry(entryName, false);
            if (entry != null) {
                SVNFileType fileType = SVNFileType.getType(file);
                boolean special = fileType == SVNFileType.SYMLINK;
                SVNNodeKind fileKind = SVNFileType.getNodeKind(fileType);
                this.handleDirEntry(dir, entryName, dirEntry, entry, fileKind, special, depth, getAll, noIgnore, handler);
            } else if (file != null) {
                SVNFileType fileType;
                if (ignorePatterns == null) {
                    ignorePatterns = SVNStatusEditor.getIgnorePatterns(dir, this.myGlobalIgnores);
                }
                boolean special = (fileType = SVNFileType.getType(file)) == SVNFileType.SYMLINK;
                SVNNodeKind fileKind = SVNFileType.getNodeKind(fileType);
                this.sendUnversionedStatus(file, entryName, fileKind, special, dir, ignorePatterns, noIgnore, handler);
            } else {
                SVNTreeConflictDescription treeConflict = this.myWCAccess.getTreeConflict(dir.getFile(entryName));
                if (treeConflict != null) {
                    if (ignorePatterns == null) {
                        ignorePatterns = SVNStatusEditor.getIgnorePatterns(dir, this.myGlobalIgnores);
                    }
                    this.sendUnversionedStatus(dir.getFile(entryName), entryName, SVNNodeKind.NONE, false, dir, ignorePatterns, true, handler);
                }
            }
            return;
        }
        if (!skipThisDir && (status = this.assembleStatus(dir.getRoot(), dir, dirEntry, parentEntry, SVNNodeKind.DIR, false, this.isReportAll(), false)) != null && handler != null) {
            handler.handleStatus(status);
        }
        if (depth == SVNDepth.EMPTY) {
            return;
        }
        childrenFiles = new TreeMap(childrenFiles);
        for (String fileName : childrenFiles.keySet()) {
            if (dir.getEntry(fileName, false) != null || SVNFileUtil.getAdminDirectoryName().equals(fileName)) continue;
            File file = (File)childrenFiles.get(fileName);
            if (depth == SVNDepth.FILES && file.isDirectory()) continue;
            if (ignorePatterns == null) {
                ignorePatterns = SVNStatusEditor.getIgnorePatterns(dir, this.myGlobalIgnores);
            }
            this.sendUnversionedStatus(file, fileName, SVNNodeKind.NONE, false, dir, ignorePatterns, noIgnore, handler);
        }
        Map treeConflicts = SVNTreeConflictUtil.readTreeConflicts(dir.getRoot(), dirEntry.getTreeConflictData());
        for (File conflictPath : treeConflicts.keySet()) {
            if (childrenFiles.containsKey(conflictPath.getName()) || dir.getEntry(conflictPath.getName(), false) != null) continue;
            if (ignorePatterns == null) {
                ignorePatterns = SVNStatusEditor.getIgnorePatterns(dir, this.myGlobalIgnores);
            }
            this.sendUnversionedStatus(conflictPath, conflictPath.getName(), SVNNodeKind.NONE, false, dir, ignorePatterns, noIgnore, handler);
        }
        Iterator entries = dir.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (dir.getThisDirName().equals(entry.getName()) || depth == SVNDepth.FILES && entry.isDirectory()) continue;
            File file = (File)childrenFiles.get(entry.getName());
            SVNFileType fileType = SVNFileType.getType(file);
            boolean special = fileType == SVNFileType.SYMLINK;
            SVNNodeKind fileKind = SVNFileType.getNodeKind(fileType);
            this.handleDirEntry(dir, entry.getName(), dirEntry, entry, fileKind, special, depth == SVNDepth.INFINITY ? depth : SVNDepth.EMPTY, getAll, noIgnore, handler);
        }
    }

    protected void cleanup() {
        if (this.hasTarget()) {
            this.myAdminInfo.removeExternal("");
            this.myAdminInfo.removeDepth("");
        }
    }

    protected SVNAdminArea getAnchor() {
        return this.myAdminInfo.getAnchor();
    }

    protected SVNWCAccess getWCAccess() {
        return this.myWCAccess;
    }

    protected SVNDepth getDepth() {
        return this.myDepth;
    }

    protected boolean isReportAll() {
        return this.myIsReportAll;
    }

    protected boolean isNoIgnore() {
        return this.myIsNoIgnore;
    }

    protected SVNAdminAreaInfo getAdminAreaInfo() {
        return this.myAdminInfo;
    }

    protected ISVNStatusHandler getDefaultHandler() {
        return this.myStatusHandler;
    }

    protected boolean hasTarget() {
        return this.myAdminInfo.getTargetName() != null && !"".equals(this.myAdminInfo.getTargetName());
    }

    protected SVNLock getLock(SVNURL url) {
        return SVNStatusUtil.getLock(this.myRepositoryLocks, url, this.myRepositoryRoot);
    }

    private void handleDirEntry(SVNAdminArea dir, String entryName, SVNEntry dirEntry, SVNEntry entry, SVNNodeKind fileKind, boolean special, SVNDepth depth, boolean getAll, boolean noIgnore, ISVNStatusHandler handler) throws SVNException {
        File path = dir.getFile(entryName);
        if (fileKind == SVNNodeKind.DIR) {
            SVNEntry fullEntry = entry;
            if (entry.getKind() == fileKind) {
                fullEntry = this.myWCAccess.getVersionedEntry(path, false);
            }
            if (fullEntry != entry && (depth == SVNDepth.UNKNOWN || depth == SVNDepth.IMMEDIATES || depth == SVNDepth.INFINITY)) {
                SVNAdminArea childDir = this.myWCAccess.retrieve(path);
                this.getDirStatus(dirEntry, childDir, null, depth, getAll, noIgnore, null, false, handler);
            } else if (fullEntry != entry) {
                SVNAdminArea childDir = this.myWCAccess.retrieve(path);
                SVNStatus status = this.assembleStatus(path, childDir, fullEntry, dirEntry, fileKind, special, getAll, false);
                if (status != null && handler != null) {
                    handler.handleStatus(status);
                }
            } else {
                SVNStatus status = this.assembleStatus(path, dir, fullEntry, dirEntry, fileKind, special, getAll, false);
                if (status != null && handler != null) {
                    handler.handleStatus(status);
                }
            }
        } else {
            SVNStatus status = this.assembleStatus(path, dir, entry, dirEntry, fileKind, special, getAll, false);
            if (status != null && handler != null) {
                handler.handleStatus(status);
            }
        }
    }

    private void sendUnversionedStatus(File file, String name, SVNNodeKind fileType, boolean special, SVNAdminArea dir, Collection ignorePatterns, boolean noIgnore, ISVNStatusHandler handler) throws SVNException {
        boolean isIgnored = SVNStatusEditor.isIgnored(ignorePatterns, file);
        String path = dir.getRelativePath(this.myAdminInfo.getAnchor());
        path = SVNPathUtil.append(path, name);
        boolean isExternal = this.isExternal(path);
        SVNStatus status = this.assembleStatus(file, dir, null, null, fileType, special, true, isIgnored);
        if (status != null) {
            if (isExternal) {
                status.setContentsStatus(SVNStatusType.STATUS_EXTERNAL);
            }
            if (handler != null && (noIgnore || !isIgnored || isExternal || status.getRemoteLock() != null)) {
                handler.handleStatus(status);
            }
        }
    }

    protected SVNStatus assembleStatus(File file, SVNAdminArea dir, SVNEntry entry, SVNEntry parentEntry, SVNNodeKind fileKind, boolean special, boolean reportAll, boolean isIgnored) throws SVNException {
        return SVNStatusUtil.assembleStatus(file, dir, entry, parentEntry, fileKind, special, reportAll, isIgnored, this.myRepositoryLocks, this.myRepositoryRoot, this.myWCAccess);
    }

    private boolean isExternal(String path) {
        if (!this.myExternalsMap.containsKey(path)) {
            for (String externalPath : this.myExternalsMap.keySet()) {
                if (!externalPath.startsWith(path + "/")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static Collection getIgnorePatterns(SVNAdminArea dir, Collection globalIgnores) throws SVNException {
        String localIgnores = dir.getProperties("").getStringPropertyValue("svn:ignore");
        if (localIgnores != null) {
            SVNHashSet patterns = new SVNHashSet();
            patterns.addAll(globalIgnores);
            StringTokenizer tokens = new StringTokenizer(localIgnores, "\r\n");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.length() <= 0) continue;
                patterns.add(token);
            }
            return patterns;
        }
        return globalIgnores;
    }

    public static Collection getGlobalIgnores(ISVNOptions options) {
        String[] ignores;
        if (options != null && (ignores = options.getIgnorePatterns()) != null) {
            SVNHashSet patterns = new SVNHashSet();
            for (int i = 0; i < ignores.length; ++i) {
                patterns.add(ignores[i]);
            }
            return patterns;
        }
        return Collections.EMPTY_SET;
    }

    public static boolean isIgnored(Collection patterns, File file) {
        boolean isDirectory;
        String name = file.getName();
        String dirName = null;
        boolean bl = isDirectory = SVNFileType.getType(file) == SVNFileType.DIRECTORY;
        if (isDirectory) {
            dirName = name + "/";
        }
        for (String pattern : patterns) {
            if (DefaultSVNOptions.matches(pattern, name)) {
                return true;
            }
            if (!isDirectory || !DefaultSVNOptions.matches(pattern, dirName)) continue;
            return true;
        }
        return false;
    }

    private static Map getChildrenFiles(File parent) {
        File[] children = SVNFileListUtil.listFiles(parent);
        if (children != null) {
            SVNHashMap map = new SVNHashMap();
            for (int i = 0; i < children.length; ++i) {
                map.put(children[i].getName(), children[i]);
            }
            return map;
        }
        return Collections.EMPTY_MAP;
    }
}

