/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNChangelistClient
extends SVNBasicClient {
    public SVNChangelistClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNChangelistClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void getChangeLists(File path, Collection changeLists, SVNDepth depth, ISVNChangelistHandler handler) throws SVNException {
        this.doGetChangeLists(path, changeLists, depth, handler);
    }

    public void getChangeListPaths(Collection changeLists, Collection targets, SVNDepth depth, ISVNChangelistHandler handler) throws SVNException {
        this.doGetChangeListPaths(changeLists, targets, depth, handler);
    }

    public void addToChangelist(File[] paths, SVNDepth depth, String changelist, String[] changelists) throws SVNException {
        this.doAddToChangelist(paths, depth, changelist, changelists);
    }

    public void removeFromChangelist(File[] paths, SVNDepth depth, String[] changelists) throws SVNException {
        this.doRemoveFromChangelist(paths, depth, changelists);
    }

    public void doAddToChangelist(File[] paths, SVNDepth depth, String changelist, String[] changelists) throws SVNException {
        this.setChangelist(paths, changelist, changelists, depth);
    }

    public void doRemoveFromChangelist(File[] paths, SVNDepth depth, String[] changelists) throws SVNException {
        this.setChangelist(paths, null, changelists, depth);
    }

    public void doGetChangeListPaths(Collection changeLists, Collection targets, SVNDepth depth, ISVNChangelistHandler handler) throws SVNException {
        if (changeLists == null || changeLists.isEmpty()) {
            return;
        }
        targets = targets == null ? Collections.EMPTY_LIST : targets;
        for (File target : targets) {
            this.doGetChangeLists(target, changeLists, depth, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetChangeLists(File path, final Collection changeLists, SVNDepth depth, final ISVNChangelistHandler handler) throws SVNException {
        path = path.getAbsoluteFile();
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            wcAccess.probeOpen(path, false, -1);
            ISVNEntryHandler entryHandler = new ISVNEntryHandler(){

                public void handleEntry(File path, SVNEntry entry) throws SVNException {
                    if (SVNWCAccess.matchesChangeList(changeLists, entry) && (entry.isFile() || entry.isDirectory() && entry.getName().equals(entry.getAdminArea().getThisDirName())) && handler != null) {
                        handler.handle(path, entry.getChangelistName());
                    }
                }

                public void handleError(File path, SVNErrorMessage error) throws SVNException {
                    SVNErrorManager.error(error, SVNLogType.WC);
                }
            };
            wcAccess.walkEntries(path, entryHandler, false, depth);
        }
        finally {
            wcAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChangelist(File[] paths, String changelistName, String[] changelists, SVNDepth depth) throws SVNException {
        if ("".equals(changelistName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Changelist names must not be empty");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        for (int i = 0; i < paths.length; ++i) {
            this.checkCancelled();
            File path = paths[i].getAbsoluteFile();
            SVNHashSet changelistsSet = null;
            if (changelists != null && changelists.length > 0) {
                changelistsSet = new SVNHashSet();
                for (int j = 0; j < changelists.length; ++j) {
                    changelistsSet.add(changelists[j]);
                }
            }
            try {
                wcAccess.probeOpen(path, true, -1);
                wcAccess.walkEntries(path, new SVNChangeListWalker(wcAccess, changelistName, changelistsSet), false, depth);
                continue;
            }
            finally {
                wcAccess.close();
            }
        }
    }

    private class SVNChangeListWalker
    implements ISVNEntryHandler {
        private String myChangelist;
        private Collection myChangelists;
        private SVNWCAccess myWCAccess;

        public SVNChangeListWalker(SVNWCAccess wcAccess, String changelistName, Collection changelists) {
            this.myChangelist = changelistName;
            this.myChangelists = changelists;
            this.myWCAccess = wcAccess;
        }

        public void handleEntry(File path, SVNEntry entry) throws SVNException {
            if (!SVNWCAccess.matchesChangeList(this.myChangelists, entry)) {
                return;
            }
            if (!entry.isFile()) {
                if (entry.isThisDir()) {
                    SVNEventAction action = this.myChangelist != null ? SVNEventAction.CHANGELIST_SET : SVNEventAction.CHANGELIST_CLEAR;
                    SVNEvent event = SVNEventFactory.createSVNEvent(path, SVNNodeKind.DIR, null, -1L, SVNEventAction.SKIP, action, null, null);
                    SVNChangelistClient.this.dispatchEvent(event);
                }
                return;
            }
            if (entry.getChangelistName() == null && this.myChangelist == null) {
                return;
            }
            if (entry.getChangelistName() != null && entry.getChangelistName().equals(this.myChangelist)) {
                return;
            }
            if (this.myChangelist != null && entry.getChangelistName() != null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CHANGELIST_MOVE, "Removing ''{0}'' from changelist ''{1}''.", new Object[]{path, entry.getChangelistName()});
                SVNEvent event = SVNEventFactory.createSVNEvent(path, SVNNodeKind.FILE, null, -1L, SVNEventAction.CHANGELIST_MOVED, SVNEventAction.CHANGELIST_MOVED, err, null);
                SVNChangelistClient.this.dispatchEvent(event);
            }
            SVNHashMap attributes = new SVNHashMap();
            attributes.put("svn:entry:changelist", this.myChangelist);
            SVNAdminArea area = this.myWCAccess.retrieve(path.getParentFile());
            entry = area.modifyEntry(entry.getName(), attributes, true, false);
            SVNEvent event = SVNEventFactory.createSVNEvent(path, SVNNodeKind.UNKNOWN, null, -1L, null, null, null, this.myChangelist != null ? SVNEventAction.CHANGELIST_SET : SVNEventAction.CHANGELIST_CLEAR, null, null, null, this.myChangelist);
            SVNChangelistClient.this.dispatchEvent(event);
        }

        public void handleError(File path, SVNErrorMessage error) throws SVNException {
            SVNErrorManager.error(error, SVNLogType.WC);
        }
    }
}

