/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminDeltifier {
    private FSFS myFSFS;
    private SVNDepth myDepth;
    private boolean myIsIncludeEntryProperties;
    private boolean myIsIgnoreAncestry;
    private boolean myIsSendTextDeltas;
    private ISVNEditor myEditor;
    private SVNDeltaCombiner myDeltaCombiner;
    private SVNDeltaGenerator myDeltaGenerator;

    public SVNAdminDeltifier(FSFS fsfs, SVNDepth depth, boolean includeEntryProperties, boolean ignoreAncestry, boolean sendTextDeltas, ISVNEditor editor) {
        this.myFSFS = fsfs;
        this.myDepth = depth;
        this.myIsIncludeEntryProperties = includeEntryProperties;
        this.myIsIgnoreAncestry = ignoreAncestry;
        this.myIsSendTextDeltas = sendTextDeltas;
        this.myEditor = editor;
        this.myDeltaCombiner = new SVNDeltaCombiner();
        this.myDeltaGenerator = new SVNDeltaGenerator();
    }

    public void setEditor(ISVNEditor editor) {
        this.myEditor = editor;
    }

    public void deltifyDir(FSRevisionRoot srcRoot, String srcParentDir, String srcEntry, FSRevisionRoot tgtRoot, String tgtFullPath) throws SVNException {
        if (srcParentDir == null) {
            SVNAdminDeltifier.generateNotADirError("source parent", srcParentDir);
        }
        if (tgtFullPath == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid target path");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String srcFullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(srcParentDir, srcEntry));
        SVNNodeKind tgtKind = tgtRoot.checkNodeKind(tgtFullPath);
        SVNNodeKind srcKind = srcRoot.checkNodeKind(srcFullPath);
        if (tgtKind == SVNNodeKind.NONE && srcKind == SVNNodeKind.NONE) {
            this.myEditor.closeEdit();
            return;
        }
        if (srcEntry == null && (srcKind != SVNNodeKind.DIR || tgtKind != SVNNodeKind.DIR)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid editor anchoring; at least one of the input paths is not a directory and there was no source entry");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        this.myEditor.targetRevision(tgtRoot.getRevision());
        long rootRevision = srcRoot.getRevision();
        if (tgtKind == SVNNodeKind.NONE) {
            this.myEditor.openRoot(rootRevision);
            this.myEditor.deleteEntry(srcEntry, -1L);
            this.myEditor.closeDir();
            this.myEditor.closeEdit();
            return;
        }
        if (srcKind == SVNNodeKind.NONE) {
            this.myEditor.openRoot(rootRevision);
            this.addFileOrDir(srcRoot, tgtRoot, tgtFullPath, srcEntry, tgtKind);
            this.myEditor.closeDir();
            this.myEditor.closeEdit();
            return;
        }
        FSRevisionNode srcNode = srcRoot.getRevisionNode(srcFullPath);
        FSRevisionNode tgtNode = tgtRoot.getRevisionNode(tgtFullPath);
        int distance = srcNode.getId().compareTo(tgtNode.getId());
        if (distance == 0) {
            this.myEditor.closeEdit();
        } else if (srcEntry != null) {
            if (srcKind != tgtKind || distance == -1) {
                this.myEditor.openRoot(rootRevision);
                this.myEditor.deleteEntry(srcEntry, -1L);
                this.addFileOrDir(srcRoot, tgtRoot, tgtFullPath, srcEntry, tgtKind);
            } else {
                this.myEditor.openRoot(rootRevision);
                this.replaceFileOrDir(srcRoot, tgtRoot, srcFullPath, tgtFullPath, srcEntry, tgtKind);
            }
            this.myEditor.closeDir();
            this.myEditor.closeEdit();
        } else {
            this.myEditor.openRoot(rootRevision);
            this.deltifyDirs(srcRoot, tgtRoot, srcFullPath, tgtFullPath, "");
            this.myEditor.closeDir();
            this.myEditor.closeEdit();
        }
    }

    private void addFileOrDir(FSRevisionRoot srcRoot, FSRevisionRoot tgtRoot, String tgtPath, String editPath, SVNNodeKind tgtKind) throws SVNException {
        if (tgtKind == SVNNodeKind.DIR) {
            this.myEditor.addDir(editPath, null, -1L);
            this.deltifyDirs(srcRoot, tgtRoot, null, tgtPath, editPath);
            this.myEditor.closeDir();
        } else {
            this.myEditor.addFile(editPath, null, -1L);
            this.deltifyFiles(srcRoot, tgtRoot, null, tgtPath, editPath);
            FSRevisionNode tgtNode = tgtRoot.getRevisionNode(tgtPath);
            this.myEditor.closeFile(editPath, tgtNode.getFileMD5Checksum());
        }
    }

    private void deltifyDirs(FSRevisionRoot srcRoot, FSRevisionRoot tgtRoot, String srcPath, String tgtPath, String editPath) throws SVNException {
        this.deltifyProperties(srcRoot, tgtRoot, srcPath, tgtPath, editPath, true);
        FSRevisionNode targetNode = tgtRoot.getRevisionNode(tgtPath);
        Map targetEntries = targetNode.getDirEntries(this.myFSFS);
        Map sourceEntries = null;
        if (srcPath != null) {
            FSRevisionNode sourceNode = srcRoot.getRevisionNode(srcPath);
            sourceEntries = sourceNode.getDirEntries(this.myFSFS);
        }
        for (String name : targetEntries.keySet()) {
            FSEntry tgtEntry = (FSEntry)targetEntries.get(name);
            SVNNodeKind tgtKind = tgtEntry.getType();
            String targetFullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(tgtPath, tgtEntry.getName()));
            String editFullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(editPath, tgtEntry.getName()));
            if (sourceEntries != null && sourceEntries.containsKey(name)) {
                FSEntry srcEntry = (FSEntry)sourceEntries.get(name);
                String sourceFullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(srcPath, tgtEntry.getName()));
                SVNNodeKind srcKind = srcEntry.getType();
                if (this.myDepth == SVNDepth.INFINITY || srcKind != SVNNodeKind.DIR) {
                    int distance = srcEntry.getId().compareTo(tgtEntry.getId());
                    if (srcKind != tgtKind || distance == -1 && !this.myIsIgnoreAncestry) {
                        this.myEditor.deleteEntry(editFullPath, -1L);
                        this.addFileOrDir(srcRoot, tgtRoot, targetFullPath, editFullPath, tgtKind);
                    } else if (distance != 0) {
                        this.replaceFileOrDir(srcRoot, tgtRoot, sourceFullPath, targetFullPath, editFullPath, tgtKind);
                    }
                }
                sourceEntries.remove(name);
                continue;
            }
            if (this.myDepth != SVNDepth.INFINITY && tgtKind == SVNNodeKind.DIR) continue;
            this.addFileOrDir(srcRoot, tgtRoot, targetFullPath, editFullPath, tgtKind);
        }
        if (sourceEntries != null) {
            for (String name : sourceEntries.keySet()) {
                FSEntry srcEntry = (FSEntry)sourceEntries.get(name);
                String editFullPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(editPath, srcEntry.getName()));
                if (this.myDepth != SVNDepth.INFINITY && srcEntry.getType() == SVNNodeKind.DIR) continue;
                this.myEditor.deleteEntry(editFullPath, -1L);
            }
        }
    }

    private void replaceFileOrDir(FSRevisionRoot srcRoot, FSRevisionRoot tgtRoot, String srcPath, String tgtPath, String editPath, SVNNodeKind tgtKind) throws SVNException {
        long baseRevision = srcRoot.getRevision();
        if (tgtKind == SVNNodeKind.DIR) {
            this.myEditor.openDir(editPath, baseRevision);
            this.deltifyDirs(srcRoot, tgtRoot, srcPath, tgtPath, editPath);
            this.myEditor.closeDir();
        } else {
            this.myEditor.openFile(editPath, baseRevision);
            this.deltifyFiles(srcRoot, tgtRoot, srcPath, tgtPath, editPath);
            FSRevisionNode tgtNode = tgtRoot.getRevisionNode(tgtPath);
            this.myEditor.closeFile(editPath, tgtNode.getFileMD5Checksum());
        }
    }

    private void deltifyFiles(FSRevisionRoot srcRoot, FSRevisionRoot tgtRoot, String srcPath, String tgtPath, String editPath) throws SVNException {
        this.deltifyProperties(srcRoot, tgtRoot, srcPath, tgtPath, editPath, false);
        boolean changed = false;
        if (srcPath != null) {
            changed = this.myIsIgnoreAncestry ? FSRepositoryUtil.checkFilesDifferent(srcRoot, srcPath, tgtRoot, tgtPath, this.myDeltaCombiner) : FSRepositoryUtil.areFileContentsChanged(srcRoot, srcPath, tgtRoot, tgtPath);
        }
        if (changed) {
            String srcHexDigest = null;
            if (srcPath != null) {
                FSRevisionNode srcNode = srcRoot.getRevisionNode(srcPath);
                srcHexDigest = srcNode.getFileMD5Checksum();
            }
            FSRepositoryUtil.sendTextDelta(this.myEditor, editPath, srcPath, srcHexDigest, srcRoot, tgtPath, tgtRoot, this.myIsSendTextDeltas, this.myDeltaCombiner, this.myDeltaGenerator, this.myFSFS);
        }
    }

    private void deltifyProperties(FSRevisionRoot srcRoot, FSRevisionRoot tgtRoot, String srcPath, String tgtPath, String editPath, boolean isDir) throws SVNException {
        FSRevisionNode node;
        long committedRevision;
        if (this.myIsIncludeEntryProperties && SVNRevision.isValidRevisionNumber(committedRevision = (node = tgtRoot.getRevisionNode(tgtPath)).getCreatedRevision())) {
            String lastAuthor;
            if (isDir) {
                this.myEditor.changeDirProperty("svn:entry:committed-rev", SVNPropertyValue.create(String.valueOf(committedRevision)));
            } else {
                this.myEditor.changeFileProperty(editPath, "svn:entry:committed-rev", SVNPropertyValue.create(String.valueOf(committedRevision)));
            }
            SVNProperties revisionProps = this.myFSFS.getRevisionProperties(committedRevision);
            String committedDateStr = revisionProps.getStringValue("svn:date");
            if (committedDateStr != null || srcPath != null) {
                if (isDir) {
                    this.myEditor.changeDirProperty("svn:entry:committed-date", SVNPropertyValue.create(committedDateStr));
                } else {
                    this.myEditor.changeFileProperty(editPath, "svn:entry:committed-date", SVNPropertyValue.create(committedDateStr));
                }
            }
            if ((lastAuthor = revisionProps.getStringValue("svn:author")) != null || srcPath != null) {
                if (isDir) {
                    this.myEditor.changeDirProperty("svn:entry:last-author", SVNPropertyValue.create(lastAuthor));
                } else {
                    this.myEditor.changeFileProperty(editPath, "svn:entry:last-author", SVNPropertyValue.create(lastAuthor));
                }
            }
            String uuid = this.myFSFS.getUUID();
            if (isDir) {
                this.myEditor.changeDirProperty("svn:entry:uuid", SVNPropertyValue.create(uuid));
            } else {
                this.myEditor.changeFileProperty(editPath, "svn:entry:uuid", SVNPropertyValue.create(uuid));
            }
        }
        FSRevisionNode targetNode = tgtRoot.getRevisionNode(tgtPath);
        SVNProperties sourceProps = null;
        if (srcPath != null) {
            boolean propsChanged;
            FSRevisionNode sourceNode = srcRoot.getRevisionNode(srcPath);
            boolean bl = propsChanged = !FSRepositoryUtil.arePropertiesEqual(sourceNode, targetNode);
            if (!propsChanged) {
                return;
            }
            sourceProps = sourceNode.getProperties(this.myFSFS);
        } else {
            sourceProps = new SVNProperties();
        }
        SVNProperties targetProps = targetNode.getProperties(this.myFSFS);
        SVNProperties propsDiffs = FSRepositoryUtil.getPropsDiffs(sourceProps, targetProps);
        Object[] names = propsDiffs.nameSet().toArray();
        for (int i = 0; i < names.length; ++i) {
            String propName = (String)names[i];
            SVNPropertyValue propValue = propsDiffs.getSVNPropertyValue(propName);
            if (isDir) {
                this.myEditor.changeDirProperty(propName, propValue);
                continue;
            }
            this.myEditor.changeFileProperty(editPath, propName, propValue);
        }
    }

    private static void generateNotADirError(String role, String path) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Invalid {0} directory ''{1}''", new Object[]{role, path != null ? path : "(null)"});
        SVNErrorManager.error(err, SVNLogType.FSFS);
    }
}

