/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.dialect;

import java.math.BigDecimal;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.gen.internal.dialect.StandardGenDialect;
import org.seasar.extension.jdbc.gen.internal.sqltype.BinaryType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BlobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BooleanType;
import org.seasar.extension.jdbc.gen.internal.sqltype.ClobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DecimalType;
import org.seasar.extension.jdbc.gen.internal.sqltype.FloatType;

public class DerbyGenDialect
extends StandardGenDialect {
    protected static String TABLE_NOT_FOUND_SQL_STATE = "42X05";
    protected static String COLUMN_NOT_FOUND_SQL_STATE = "42X04";

    public DerbyGenDialect() {
        this.sqlTypeMap.put(-2, new BinaryType("varchar($l) for bit data"));
        this.sqlTypeMap.put(2004, new BlobType("blob($l)"));
        this.sqlTypeMap.put(16, new BooleanType("smallint"));
        this.sqlTypeMap.put(2005, new ClobType("clob($l)"));
        this.sqlTypeMap.put(3, new DecimalType("decimal($p,$s)"));
        this.sqlTypeMap.put(6, new FloatType("real"));
        this.columnTypeMap.put("blob", DerbyColumnType.BLOB);
        this.columnTypeMap.put("char () for bit data", DerbyColumnType.CHAR_BIT);
        this.columnTypeMap.put("clob", DerbyColumnType.CLOB);
        this.columnTypeMap.put("decimal", DerbyColumnType.DECIMAL);
        this.columnTypeMap.put("long varchar for bit data", DerbyColumnType.LONGVARCHAR_BIT);
        this.columnTypeMap.put("long varchar", DerbyColumnType.LONGVARCHAR);
        this.columnTypeMap.put("varchar () for bit data", DerbyColumnType.VARCHAR_BIT);
    }

    public String getName() {
        return "derby";
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    public String getIdentityColumnDefinition() {
        return "not null generated by default as identity";
    }

    public boolean isTableNotFound(Throwable throwable) {
        String sqlState = this.getSQLState(throwable);
        return TABLE_NOT_FOUND_SQL_STATE.equals(sqlState);
    }

    public boolean isColumnNotFound(Throwable throwable) {
        String sqlState = this.getSQLState(throwable);
        return COLUMN_NOT_FOUND_SQL_STATE.equals(sqlState);
    }

    public boolean supportsIdentityInsert() {
        return true;
    }

    public boolean supportsIdentity() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DerbyColumnType
    extends StandardGenDialect.StandardColumnType {
        private static DerbyColumnType BLOB = new DerbyColumnType("blob($l)", byte[].class);
        private static DerbyColumnType CHAR_BIT = new DerbyColumnType("char($l) for bit data", byte[].class);
        private static DerbyColumnType CLOB = new DerbyColumnType("clob($l)", String.class);
        private static DerbyColumnType DECIMAL = new DerbyColumnType("decimal($p,$s)", BigDecimal.class);
        private static DerbyColumnType LONGVARCHAR_BIT = new DerbyColumnType("long varchar for bit data", byte[].class);
        private static DerbyColumnType LONGVARCHAR = new DerbyColumnType("long varchar", String.class);
        private static DerbyColumnType VARCHAR_BIT = new DerbyColumnType("varchar($l) for bit data", byte[].class);

        public DerbyColumnType(String dataType, Class<?> attributeClass) {
            super(dataType, attributeClass);
        }

        public DerbyColumnType(String dataType, Class<?> attributeClass, boolean lob) {
            super(dataType, attributeClass, lob);
        }
    }
}

