/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.gen.desc.AttributeDesc;
import org.seasar.extension.jdbc.gen.model.AttributeModel;
import org.seasar.extension.jdbc.gen.model.AttributeModelFactory;
import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.util.ClassUtil;

public class AttributeModelFactoryImpl
implements AttributeModelFactory {
    protected boolean showColumnName;
    protected boolean showColumnDefinition;
    protected PersistenceConvention persistenceConvention;
    protected boolean useTemporalType;

    public AttributeModelFactoryImpl(boolean showColumnName, boolean showColumnDefinition, boolean useTemporalType, PersistenceConvention persistenceConvention) {
        if (persistenceConvention == null) {
            throw new NullPointerException("persistenceConvention");
        }
        this.showColumnName = showColumnName;
        this.showColumnDefinition = showColumnDefinition;
        this.useTemporalType = useTemporalType;
        this.persistenceConvention = persistenceConvention;
    }

    public AttributeModel getAttributeModel(AttributeDesc attributeDesc) {
        AttributeModel attributeModel = new AttributeModel();
        attributeModel.setName(attributeDesc.getName());
        attributeModel.setId(attributeDesc.isId());
        attributeModel.setGenerationType(attributeDesc.getGenerationType());
        attributeModel.setInitialValue(attributeDesc.getInitialValue());
        attributeModel.setAllocationSize(attributeDesc.getAllocationSize());
        attributeModel.setLob(attributeDesc.isLob());
        attributeModel.setTransient(attributeDesc.isTransient());
        attributeModel.setVersion(attributeDesc.isVersion());
        attributeModel.setNullable(attributeDesc.isNullable());
        attributeModel.setUnique(attributeDesc.isUnique());
        attributeModel.setColumnTypeName(attributeDesc.getColumnTypeName());
        attributeModel.setComment(attributeDesc.getComment());
        this.doAttributeClass(attributeModel, attributeDesc);
        this.doColumnName(attributeModel, attributeDesc);
        if (this.showColumnDefinition) {
            this.doColumnDefinition(attributeModel, attributeDesc);
        } else {
            this.doLength(attributeModel, attributeDesc);
            this.doPrecision(attributeModel, attributeDesc);
            this.doScale(attributeModel, attributeDesc);
        }
        return attributeModel;
    }

    protected void doAttributeClass(AttributeModel attributeModel, AttributeDesc attributeDesc) {
        TemporalType primaryTemporalType = attributeDesc.getPrimaryTemporalType();
        if (primaryTemporalType != null) {
            attributeModel.setTemporalType(primaryTemporalType);
            attributeModel.setAttributeClass(Date.class);
        } else if (this.useTemporalType && attributeDesc.isTemporal()) {
            attributeModel.setTemporalType(attributeDesc.getTemporalType());
            attributeModel.setAttributeClass(Date.class);
        } else {
            attributeModel.setAttributeClass(attributeDesc.getAttributeClass());
        }
    }

    protected void doColumnName(AttributeModel attributeModel, AttributeDesc attributeDesc) {
        String realColumnName = attributeDesc.getColumnName();
        String convertedColumnName = this.persistenceConvention.fromPropertyNameToColumnName(attributeModel.getName());
        if (this.showColumnName || !realColumnName.equalsIgnoreCase(convertedColumnName)) {
            attributeModel.setColumnName(realColumnName);
        }
    }

    protected void doColumnDefinition(AttributeModel attributeModel, AttributeDesc attributeDesc) {
        attributeModel.setColumnDefinition(attributeDesc.getColumnDefinition());
        attributeModel.setUnsupportedColumnType(attributeDesc.isUnsupportedColumnType());
    }

    protected void doLength(AttributeModel attributeModel, AttributeDesc attributeDesc) {
        if (attributeDesc.getLength() < 1) {
            return;
        }
        Class clazz = ClassUtil.getWrapperClassIfPrimitive(attributeDesc.getAttributeClass());
        if (!(Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz))) {
            attributeModel.setLength(attributeDesc.getLength());
        }
    }

    protected void doPrecision(AttributeModel attributeModel, AttributeDesc attributeDesc) {
        if (attributeDesc.getPrecision() < 1) {
            return;
        }
        Class clazz = ClassUtil.getWrapperClassIfPrimitive(attributeDesc.getAttributeClass());
        if (Number.class.isAssignableFrom(clazz)) {
            attributeModel.setPrecision(attributeDesc.getPrecision());
        }
    }

    protected void doScale(AttributeModel attributeModel, AttributeDesc attributeDesc) {
        if (attributeDesc.getScale() < 1) {
            return;
        }
        Class clazz = ClassUtil.getWrapperClassIfPrimitive(attributeDesc.getAttributeClass());
        if (clazz == BigDecimal.class || clazz == Float.class || clazz == Double.class) {
            attributeModel.setScale(attributeDesc.getScale());
        }
    }
}

