/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import java.io.File;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.gen.generator.GenerationContext;
import org.seasar.extension.jdbc.gen.generator.Generator;
import org.seasar.extension.jdbc.gen.internal.command.AbstractCommand;
import org.seasar.extension.jdbc.gen.internal.exception.RequiredPropertyNullRuntimeException;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.extension.jdbc.gen.meta.EntityMetaReader;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.EntityTestModel;
import org.seasar.extension.jdbc.gen.model.EntityTestModelFactory;
import org.seasar.extension.jdbc.gen.model.NamesModelFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;

public class GenerateEntityTestCommand
extends AbstractCommand {
    protected static Logger logger = Logger.getLogger(GenerateEntityTestCommand.class);
    protected File classpathDir;
    protected String rootPackageName = "";
    protected String entityPackageName = "entity";
    protected String entityClassNamePattern = ".*";
    protected String ignoreEntityClassNamePattern = "";
    protected String testClassNameSuffix = "Test";
    protected boolean useS2junit4;
    protected String templateFileName = "java/entitytest.ftl";
    protected String templateFileEncoding = "UTF-8";
    protected File templateFilePrimaryDir = null;
    protected boolean useNamesClass = true;
    protected String namesClassNameSuffix = "Names";
    protected String namesPackageName = "entity";
    protected File javaFileDestDir = new File(new File("src", "test"), "java");
    protected String javaFileEncoding = "UTF-8";
    protected boolean overwrite = false;
    protected EntityMetaReader entityMetaReader;
    protected EntityTestModelFactory entityTestModelFactory;
    protected NamesModelFactory namesModelFactory;
    protected Generator generator;

    public String getTestClassNameSuffix() {
        return this.testClassNameSuffix;
    }

    public void setTestClassNameSuffix(String testClassNameSuffix) {
        this.testClassNameSuffix = testClassNameSuffix;
    }

    public String getEntityPackageName() {
        return this.entityPackageName;
    }

    public void setEntityPackageName(String entityPackageName) {
        this.entityPackageName = entityPackageName;
    }

    public String getEntityClassNamePattern() {
        return this.entityClassNamePattern;
    }

    public void setEntityClassNamePattern(String entityClassNamePattern) {
        this.entityClassNamePattern = entityClassNamePattern;
    }

    public String getIgnoreEntityClassNamePattern() {
        return this.ignoreEntityClassNamePattern;
    }

    public void setIgnoreEntityClassNamePattern(String ignoreEntityClassNamePattern) {
        this.ignoreEntityClassNamePattern = ignoreEntityClassNamePattern;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public File getJavaFileDestDir() {
        return this.javaFileDestDir;
    }

    public void setJavaFileDestDir(File javaFileDestDir) {
        this.javaFileDestDir = javaFileDestDir;
    }

    public String getJavaFileEncoding() {
        return this.javaFileEncoding;
    }

    public void setJavaFileEncoding(String javaFileEncoding) {
        this.javaFileEncoding = javaFileEncoding;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getRootPackageName() {
        return this.rootPackageName;
    }

    public void setRootPackageName(String rootPackageName) {
        this.rootPackageName = rootPackageName;
    }

    public String getTemplateFileEncoding() {
        return this.templateFileEncoding;
    }

    public void setTemplateFileEncoding(String templateFileEncoding) {
        this.templateFileEncoding = templateFileEncoding;
    }

    public File getTemplateFilePrimaryDir() {
        return this.templateFilePrimaryDir;
    }

    public void setTemplateFilePrimaryDir(File templateFilePrimaryDir) {
        this.templateFilePrimaryDir = templateFilePrimaryDir;
    }

    public File getClasspathDir() {
        return this.classpathDir;
    }

    public void setClasspathDir(File classpathDir) {
        this.classpathDir = classpathDir;
    }

    public boolean isUseS2junit4() {
        return this.useS2junit4;
    }

    public void setUseS2junit4(boolean useS2junit4) {
        this.useS2junit4 = useS2junit4;
    }

    public String getNamesClassNameSuffix() {
        return this.namesClassNameSuffix;
    }

    public void setNamesClassNameSuffix(String namesClassNameSuffix) {
        this.namesClassNameSuffix = namesClassNameSuffix;
    }

    public String getNamesPackageName() {
        return this.namesPackageName;
    }

    public void setNamesPackageName(String namesPackageName) {
        this.namesPackageName = namesPackageName;
    }

    public boolean isUseNamesClass() {
        return this.useNamesClass;
    }

    public void setUseNamesClass(boolean useNamesClass) {
        this.useNamesClass = useNamesClass;
    }

    protected void doValidate() {
        if (this.classpathDir == null) {
            throw new RequiredPropertyNullRuntimeException("classpathDir");
        }
    }

    protected void doInit() {
        this.entityMetaReader = this.createEntityMetaReader();
        this.namesModelFactory = this.createNamesModelFactory();
        this.entityTestModelFactory = this.createEntityTestModelFactory();
        this.generator = this.createGenerator();
    }

    protected void doExecute() {
        for (EntityMeta entityMeta : this.entityMetaReader.read()) {
            this.generateTest(entityMeta);
        }
    }

    protected void doDestroy() {
    }

    protected void generateTest(EntityMeta entityMeta) {
        EntityTestModel entityTestModel = this.entityTestModelFactory.getEntityTestModel(entityMeta);
        GenerationContext context = this.createGenerationContext(entityTestModel, this.templateFileName);
        this.generator.generate(context);
    }

    protected EntityMetaReader createEntityMetaReader() {
        return this.factory.createEntityMetaReader(this, this.classpathDir, ClassUtil.concatName((String)this.rootPackageName, (String)this.entityPackageName), this.jdbcManager.getEntityMetaFactory(), this.entityClassNamePattern, this.ignoreEntityClassNamePattern, false, null, null);
    }

    protected NamesModelFactory createNamesModelFactory() {
        return this.factory.createNamesModelFactory(this, ClassUtil.concatName((String)this.rootPackageName, (String)this.namesPackageName), this.namesClassNameSuffix);
    }

    protected EntityTestModelFactory createEntityTestModelFactory() {
        return this.factory.createEntityTestModelFactory(this, this.configPath, this.jdbcManagerName, this.testClassNameSuffix, this.namesModelFactory, this.useNamesClass, this.useS2junit4);
    }

    protected Generator createGenerator() {
        return this.factory.createGenerator(this, this.templateFileEncoding, this.templateFilePrimaryDir);
    }

    protected GenerationContext createGenerationContext(ClassModel model, String templateName) {
        File file = FileUtil.createJavaFile(this.javaFileDestDir, model.getPackageName(), model.getShortClassName());
        return this.factory.createGenerationContext(this, model, file, templateName, this.javaFileEncoding, this.overwrite);
    }

    protected Logger getLogger() {
        return logger;
    }
}

