/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.argtype;

import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentType;
import org.seasar.framework.util.NumberConversionUtil;
import org.seasar.framework.util.StringConversionUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberType<T extends Number>
implements ArgumentType<T> {
    protected Class<T> numberClass;

    public NumberType(Class<T> numberClass) {
        this.numberClass = numberClass;
    }

    @Override
    public T toObject(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        Object number = NumberConversionUtil.convertNumber(this.numberClass, (Object)value);
        return (T)((Number)this.numberClass.cast(number));
    }

    @Override
    public String toText(T value) {
        if (value == null) {
            return "";
        }
        return StringConversionUtil.toString(value);
    }
}

