/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.timer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.extension.timer.TimeoutTarget;
import org.seasar.extension.timer.TimeoutTask;
import org.seasar.framework.util.SLinkedList;

public class TimeoutManager
implements Runnable {
    protected static final TimeoutManager instance = new TimeoutManager();
    protected Thread thread;
    protected final SLinkedList timeoutTaskList = new SLinkedList();

    private TimeoutManager() {
    }

    public static TimeoutManager getInstance() {
        return instance;
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Seasar2-TimeoutManager");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public synchronized void clear() {
        this.timeoutTaskList.clear();
    }

    public synchronized TimeoutTask addTimeoutTarget(TimeoutTarget timeoutTarget, int timeout, boolean permanent) {
        TimeoutTask task = new TimeoutTask(timeoutTarget, timeout, permanent);
        this.timeoutTaskList.addLast((Object)task);
        if (this.timeoutTaskList.size() == 1) {
            this.start();
        }
        return task;
    }

    public synchronized int getTimeoutTaskCount() {
        return this.timeoutTaskList.size();
    }

    public void run() {
        while (true) {
            List expiredTask = this.getExpiredTask();
            Iterator it = expiredTask.iterator();
            while (it.hasNext()) {
                TimeoutTask task = (TimeoutTask)it.next();
                task.expired();
                if (!task.isPermanent()) continue;
                task.restart();
            }
            if (this.stopIfLeisure()) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected synchronized List getExpiredTask() {
        ArrayList<TimeoutTask> expiredTask = new ArrayList<TimeoutTask>();
        if (this.timeoutTaskList == null || this.timeoutTaskList.isEmpty()) {
            return expiredTask;
        }
        for (SLinkedList.Entry e = this.timeoutTaskList.getFirstEntry(); e != null; e = e.getNext()) {
            TimeoutTask task = (TimeoutTask)e.getElement();
            if (task.isCanceled()) {
                e.remove();
                continue;
            }
            if (task.isStopped() || !task.isExpired()) continue;
            expiredTask.add(task);
            if (task.isPermanent()) continue;
            e.remove();
        }
        return expiredTask;
    }

    protected synchronized boolean stopIfLeisure() {
        if (this.timeoutTaskList == null || this.timeoutTaskList.isEmpty()) {
            this.thread = null;
            return true;
        }
        return false;
    }
}

