/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.StringValueEval;

public class NumberEval
implements NumericValueEval,
StringValueEval {
    public static final NumberEval ZERO = new NumberEval(0.0);
    private double value;
    private String stringValue;

    public NumberEval(Ptg ptg) {
        if (ptg instanceof IntPtg) {
            this.value = ((IntPtg)ptg).getValue();
        } else if (ptg instanceof NumberPtg) {
            this.value = ((NumberPtg)ptg).getValue();
        }
    }

    public NumberEval(double value) {
        this.value = value;
    }

    public double getNumberValue() {
        return this.value;
    }

    public String getStringValue() {
        if (this.stringValue == null) {
            this.makeString();
        }
        return this.stringValue;
    }

    protected void makeString() {
        if (!Double.isNaN(this.value)) {
            long lvalue = Math.round(this.value);
            this.stringValue = (double)lvalue == this.value ? String.valueOf(lvalue) : String.valueOf(this.value);
        }
    }
}

