/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.autoregister.AbstractAutoRegister;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.util.ClassUtil;

public abstract class AbstractComponentTargetAutoRegister
extends AbstractAutoRegister {
    public void registerAll() {
        S2Container container = this.getContainer();
        for (int i = 0; i < container.getComponentDefSize(); ++i) {
            ComponentDef cd = container.getComponentDef(i);
            if (!this.isAppliedComponent(cd)) continue;
            this.register(cd);
        }
    }

    protected abstract void register(ComponentDef var1);

    protected boolean isAppliedComponent(ComponentDef cd) {
        Class componentClass = cd.getComponentClass();
        if (componentClass == null) {
            return false;
        }
        String packageName = ClassUtil.getPackageName(componentClass);
        String shortClassName = ClassUtil.getShortClassName(componentClass);
        for (int i = 0; i < this.getClassPatternSize(); ++i) {
            ClassPattern cp = this.getClassPattern(i);
            if (this.isIgnore(packageName, shortClassName)) {
                return false;
            }
            if (!cp.isAppliedPackageName(packageName) || !cp.isAppliedShortClassName(shortClassName)) continue;
            return true;
        }
        return false;
    }
}

