/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hslf.model.Background;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.record.MainMaster;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.TxMasterStyleAtom;
import org.apache.poi.hslf.usermodel.SlideShow;

public class SlideMaster
extends MasterSheet {
    private int _refSheetNo;
    private int _sheetNo;
    private MainMaster _master;
    private TextRun[] _runs;
    private Background _background;
    private TxMasterStyleAtom[] _txmaster;

    public SlideMaster(MainMaster rec, int slideId) {
        this._master = rec;
        this._refSheetNo = rec.getSheetId();
        this._sheetNo = slideId;
        this._runs = SlideMaster.findTextRuns(this._master.getPPDrawing());
    }

    public TextRun[] getTextRuns() {
        return this._runs;
    }

    public int _getSheetRefId() {
        return this._refSheetNo;
    }

    public int _getSheetNumber() {
        return this._sheetNo;
    }

    protected PPDrawing getPPDrawing() {
        return this._master.getPPDrawing();
    }

    public TextProp getStyleAttribute(int txtype, int level, String name, boolean isCharacter) {
        TextProp prop = null;
        for (int i = level; i >= 0; --i) {
            TextPropCollection[] styles;
            TextPropCollection[] textPropCollectionArray = styles = isCharacter ? this._txmaster[txtype].getCharacterStyles() : this._txmaster[txtype].getParagraphStyles();
            if (i < styles.length) {
                prop = styles[i].findByName(name);
            }
            if (prop != null) break;
        }
        if (prop == null) {
            switch (txtype) {
                case 5: 
                case 7: 
                case 8: {
                    txtype = 1;
                    break;
                }
                case 6: {
                    txtype = 0;
                    break;
                }
                default: {
                    return null;
                }
            }
            prop = this.getStyleAttribute(txtype, level, name, isCharacter);
        }
        return prop;
    }

    public void setSlideShow(SlideShow ss) {
        super.setSlideShow(ss);
        if (this._txmaster == null) {
            TxMasterStyleAtom txdoc;
            this._txmaster = new TxMasterStyleAtom[9];
            this._txmaster[txdoc.getTextType()] = txdoc = this.getSlideShow().getDocumentRecord().getEnvironment().getTxMasterStyleAtom();
            TxMasterStyleAtom[] txrec = this._master.getTxMasterStyleAtoms();
            for (int i = 0; i < txrec.length; ++i) {
                this._txmaster[txrec[i].getTextType()] = txrec[i];
            }
        }
    }

    public ColorSchemeAtom getColorScheme() {
        return this._master.getColorScheme();
    }

    public Background getBackground() {
        if (this._background == null) {
            PPDrawing ppdrawing = this.getPPDrawing();
            EscherContainerRecord dg = (EscherContainerRecord)ppdrawing.getEscherRecords()[0];
            EscherContainerRecord spContainer = null;
            List ch = dg.getChildRecords();
            Iterator it = ch.iterator();
            while (it.hasNext()) {
                EscherRecord rec = (EscherRecord)it.next();
                if (rec.getRecordId() != -4092) continue;
                spContainer = (EscherContainerRecord)rec;
                break;
            }
            this._background = new Background(spContainer, null);
            this._background.setSheet(this);
        }
        return this._background;
    }
}

