/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.spi.impl;

import java.util.HashMap;
import java.util.Map;
import org.seasar.cubby.converter.Converter;
import org.seasar.cubby.spi.impl.AbstractConverterProvider;
import org.seasar.cubby.spi.impl.ConversionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCachedConverterProvider
extends AbstractConverterProvider {
    private final Map<String, Converter> converterCache = new HashMap<String, Converter>();

    @Override
    public Converter getConverter(Class<?> parameterType, Class<?> objectType) {
        Class<?> destType = ConversionUtils.getWrapperClassIfPrimitive(objectType);
        String cacheKey = AbstractCachedConverterProvider.cacheKey(parameterType, destType);
        Converter converter = this.converterCache.get(cacheKey);
        if (converter != null) {
            return converter;
        }
        return this.detectConverter(parameterType, destType);
    }

    private Converter detectConverter(Class<?> parameterType, Class<?> objectType) {
        Converter converter = super.getConverter(parameterType, objectType);
        String cacheKey = AbstractCachedConverterProvider.cacheKey(parameterType, objectType);
        this.converterCache.put(cacheKey, converter);
        return converter;
    }

    private static String cacheKey(Class<?> parameterType, Class<?> objectType) {
        if (parameterType == null) {
            return objectType.getName();
        }
        return parameterType.getName() + objectType.getName();
    }

    protected void clear() {
        this.converterCache.clear();
    }
}

