/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.fileupload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;

public class StreamFileItemFactory
implements FileItemFactory {
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 8192;
    private int initialBufferSize = 8192;

    public void setInitialBufferSize(int initialBufferSize) {
        this.initialBufferSize = initialBufferSize;
    }

    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        return new ByteArrayFileItem(fieldName, contentType, isFormField, fileName, this.initialBufferSize);
    }

    private static class ByteArrayFileItem
    implements FileItem {
        private static final long serialVersionUID = 1L;
        private String fieldName;
        private final String contentType;
        private boolean isFormField;
        private final String fileName;
        private final int initialBufferSize;
        private transient ByteArrayOutputStream outputStream;
        private byte[] data;

        public ByteArrayFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int initialBufferSize) {
            this.fieldName = fieldName;
            this.contentType = contentType;
            this.isFormField = isFormField;
            this.fileName = fileName;
            this.initialBufferSize = initialBufferSize;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.get());
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return this.fileName;
        }

        public boolean isInMemory() {
            return true;
        }

        public long getSize() {
            return this.get().length;
        }

        public byte[] get() {
            if (this.data == null) {
                this.data = this.outputStream.toByteArray();
            }
            return this.data;
        }

        public String getString(String encoding) throws UnsupportedEncodingException {
            return new String(this.get(), encoding);
        }

        public String getString() {
            return new String(this.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(File file) throws Exception {
            FileOutputStream out = new FileOutputStream(file);
            try {
                out.write(this.get());
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }

        public void delete() {
            this.data = null;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String name) {
            this.fieldName = name;
        }

        public boolean isFormField() {
            return this.isFormField;
        }

        public void setFormField(boolean state) {
            this.isFormField = state;
        }

        public OutputStream getOutputStream() {
            if (this.outputStream == null) {
                this.outputStream = new ByteArrayOutputStream(this.initialBufferSize);
            }
            return this.outputStream;
        }
    }
}

