/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.sift;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.sift.Discriminator;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDCBasedDiscriminator
extends ContextAwareBase
implements Discriminator<LoggingEvent> {
    private String key;
    private String defaultValue;
    private boolean started = false;

    public String getDiscriminatingValue(LoggingEvent event) {
        String mdcValue = MDC.get((String)this.key);
        if (mdcValue == null) {
            return this.defaultValue;
        }
        return mdcValue;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        int errors = 0;
        if (OptionHelper.isEmpty((String)this.key)) {
            ++errors;
            this.addError("The \"Key\" property must be set");
        }
        if (OptionHelper.isEmpty((String)this.defaultValue)) {
            ++errors;
            this.addError("The \"DefaultValue\" property must be set");
        }
        if (errors == 0) {
            this.started = true;
        }
    }

    public void stop() {
        this.started = false;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

