/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.impl;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.spi.PersistenceUnitInfo;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.framework.jpa.PersistenceUnitInfoFactory;
import org.seasar.framework.jpa.PersistenceUnitInfoRegistry;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

public class PersistenceUnitInfoRegistryImpl
implements PersistenceUnitInfoRegistry {
    public static final String PERSISTENCE_XML = "META-INF/persistence.xml";
    private static final Logger logger = Logger.getLogger(PersistenceUnitInfoRegistryImpl.class);
    protected PersistenceUnitInfoFactory persistenceUnitInfoFactory;
    protected Map<String, PersistenceUnitInfo> unitInfoMap = CollectionsUtil.newHashMap();

    @Binding(bindingType=BindingType.MUST)
    public void setPersistenceUnitInfoFactory(PersistenceUnitInfoFactory persistenceUnitInfoFactory) {
        this.persistenceUnitInfoFactory = persistenceUnitInfoFactory;
    }

    @InitMethod
    public void load() {
        Iterator it = ClassLoaderUtil.getResources((String)PERSISTENCE_XML);
        while (it.hasNext()) {
            URL url = (URL)it.next();
            logger.log("ISSR0006", new Object[]{url});
            try {
                for (PersistenceUnitInfo unitInfo : this.persistenceUnitInfoFactory.createPersistenceUnitInfo(url)) {
                    String unitName = unitInfo.getPersistenceUnitName();
                    if (this.unitInfoMap.containsKey(unitName)) continue;
                    logger.log("ISSR0007", new Object[]{unitName});
                    this.unitInfoMap.put(unitName, unitInfo);
                }
            }
            catch (Exception e) {
                logger.log("WSSR0012", new Object[]{e}, (Throwable)e);
            }
        }
    }

    public PersistenceUnitInfo getPersistenceUnitInfo(String name) {
        return this.unitInfoMap.get(name);
    }
}

