/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.dialect;

import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.SelectForUpdateType;
import org.seasar.extension.jdbc.dialect.StandardDialect;
import org.seasar.framework.util.tiger.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MssqlDialect
extends StandardDialect {
    @Override
    public String getName() {
        return "mssql";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return false;
    }

    @Override
    public String convertLimitSql(String sql, int offset, int limit) {
        StringBuilder buf = new StringBuilder(sql.length() + 20);
        String lowerSql = sql.toLowerCase();
        int startOfSelect = lowerSql.indexOf("select");
        int endOfSelect = startOfSelect + 6;
        if (" distinct".equals(lowerSql.substring(6, 15))) {
            endOfSelect = startOfSelect + 15;
        }
        buf.append(sql.substring(0, endOfSelect));
        buf.append(" top ");
        buf.append(offset + limit);
        buf.append(sql.substring(endOfSelect));
        return buf.toString();
    }

    @Override
    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public boolean supportsForUpdate(SelectForUpdateType type, boolean withTarget) {
        return type != SelectForUpdateType.WAIT;
    }

    @Override
    public String getForUpdateString(SelectForUpdateType type, int waitSeconds, Pair<String, String> ... aliases) {
        return "";
    }

    @Override
    public boolean supportsLockHint() {
        return true;
    }

    @Override
    public String getLockHintString(SelectForUpdateType type, int waitSeconds) {
        StringBuilder buf = new StringBuilder(100).append(" with (updlock, rowlock");
        if (type == SelectForUpdateType.NOWAIT) {
            buf.append(", nowait");
        }
        buf.append(")");
        return new String(buf);
    }
}

