/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.Assert;

public class StaticMessageSource
extends AbstractMessageSource {
    private final Map messages = new HashMap();

    protected MessageFormat resolveCode(String code, Locale locale) {
        return (MessageFormat)this.messages.get(code + "_" + locale.toString());
    }

    public void addMessage(String code, Locale locale, String msg) {
        Assert.notNull((Object)code, (String)"Code must not be null");
        Assert.notNull((Object)locale, (String)"Locale must not be null");
        Assert.notNull((Object)msg, (String)"Message must not be null");
        this.messages.put(code + "_" + locale.toString(), this.createMessageFormat(msg, locale));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added message [" + msg + "] for code [" + code + "] and Locale [" + locale + "]"));
        }
    }

    public void addMessages(Map messages, Locale locale) {
        Assert.notNull((Object)messages, (String)"Messages Map must not be null");
        Iterator it = messages.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.addMessage(entry.getKey().toString(), locale, entry.getValue().toString());
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.messages;
    }
}

