/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.IntermediateInputStream;
import org.apache.tomcat.util.buf.ReadConvertor;

public class B2CConverter {
    private static Log log = LogFactory.getLog(B2CConverter.class);
    private IntermediateInputStream iis;
    private ReadConvertor conv;
    private String encoding;
    static final int BUFFER_SIZE = 8192;
    char[] result = new char[8192];
    private final int debug = 0;

    protected B2CConverter() {
    }

    public B2CConverter(String encoding) throws IOException {
        this.encoding = encoding;
        this.reset();
    }

    public void recycle() {
        this.conv.recycle();
    }

    public void convert(ByteChunk bb, CharChunk cb) throws IOException {
        this.convert(bb, cb, cb.getBuffer().length - cb.getEnd());
    }

    public void convert(ByteChunk bb, CharChunk cb, int limit) throws IOException {
        this.iis.setByteChunk(bb);
        try {
            int bbLengthBeforeRead = 0;
            while (limit > 0) {
                int size = limit < 8192 ? limit : 8192;
                bbLengthBeforeRead = bb.getLength();
                int cnt = this.conv.read(this.result, 0, size);
                if (cnt <= 0) {
                    return;
                }
                cb.append(this.result, 0, cnt);
                limit -= bbLengthBeforeRead - bb.getLength();
            }
        }
        catch (IOException ex) {
            this.reset();
            throw ex;
        }
    }

    public void reset() throws IOException {
        this.iis = new IntermediateInputStream();
        this.conv = new ReadConvertor(this.iis, this.encoding);
    }

    void log(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("B2CConverter: " + s));
        }
    }
}

