/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.tx.adapter;

import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.seasar.extension.tx.TransactionCallback;
import org.seasar.extension.tx.TransactionManagerAdapter;
import org.seasar.framework.exception.SIllegalStateException;
import org.seasar.framework.log.Logger;

public class JTATransactionManagerAdapter
implements TransactionManagerAdapter,
Status {
    private static final Logger logger = Logger.getLogger((Class)JTATransactionManagerAdapter.class);
    protected final UserTransaction userTransaction;
    protected final TransactionManager transactionManager;

    public JTATransactionManagerAdapter(UserTransaction userTransaction, TransactionManager transactionManager) {
        this.userTransaction = userTransaction;
        this.transactionManager = transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object required(TransactionCallback callback) throws Throwable {
        boolean began = this.begin();
        try {
            Object object = callback.execute(this);
            return object;
        }
        finally {
            if (began) {
                this.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object requiresNew(TransactionCallback callback) throws Throwable {
        Transaction tx = this.suspend();
        try {
            Object object;
            this.begin();
            try {
                object = callback.execute(this);
            }
            catch (Throwable throwable) {
                this.end();
                throw throwable;
            }
            this.end();
            return object;
        }
        finally {
            if (tx != null) {
                this.resume(tx);
            }
        }
    }

    public Object mandatory(TransactionCallback callback) throws Throwable {
        if (!this.hasTransaction()) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        return callback.execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object notSupported(TransactionCallback callback) throws Throwable {
        Transaction tx = this.suspend();
        try {
            Object object = callback.execute(this);
            return object;
        }
        finally {
            if (tx != null) {
                this.resume(tx);
            }
        }
    }

    public Object never(TransactionCallback callback) throws Throwable {
        if (this.hasTransaction()) {
            throw new SIllegalStateException("ESSR0317", null);
        }
        return callback.execute(this);
    }

    public void setRollbackOnly() {
        try {
            if (this.userTransaction.getStatus() == 0) {
                this.userTransaction.setRollbackOnly();
            }
        }
        catch (Exception e) {
            logger.log("ESSR0017", new Object[]{e.getMessage()}, (Throwable)e);
        }
    }

    protected boolean hasTransaction() throws SystemException {
        int status = this.userTransaction.getStatus();
        return status != 6 && status != 5;
    }

    protected boolean begin() throws Exception {
        if (this.hasTransaction()) {
            return false;
        }
        this.userTransaction.begin();
        return true;
    }

    protected void end() throws Exception {
        if (this.userTransaction.getStatus() == 0) {
            this.userTransaction.commit();
        } else {
            this.userTransaction.rollback();
        }
    }

    protected Transaction suspend() throws Exception {
        return this.hasTransaction() ? this.transactionManager.suspend() : null;
    }

    protected void resume(Transaction transaction) throws Exception {
        this.transactionManager.resume(transaction);
    }
}

