/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.filter;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.seasar.cubby.controller.FormWrapperFactory;
import org.seasar.cubby.controller.MessagesBehaviour;
import org.seasar.cubby.filter.CubbyFilter;
import org.seasar.cubby.internal.controller.impl.FormWrapperFactoryImpl;
import org.seasar.cubby.internal.util.IteratorEnumeration;
import org.seasar.cubby.spi.beans.Attribute;
import org.seasar.cubby.spi.beans.BeanDesc;
import org.seasar.cubby.spi.beans.BeanDescFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CubbyHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final CubbyFilter cubbyFilter;
    private final Map<String, String[]> uriParameters;
    private FormWrapperFactory formWrapperFactory;
    private MessagesBehaviour messagesBehaviour;

    CubbyHttpServletRequestWrapper(CubbyFilter cubbyFilter, HttpServletRequest request, Map<String, String[]> uriParameters) {
        super(request);
        this.cubbyFilter = cubbyFilter;
        this.uriParameters = uriParameters;
    }

    public Object getAttribute(String name) {
        Object value;
        if ("contextPath".equals(name)) {
            value = this.getContextPath();
        } else if ("messages".equals(name)) {
            value = CubbyHttpServletRequestWrapper.getMessagesAsMap(this.getRequest(), this.getMessagesBehaviour());
        } else if ("org.seasar.cubby.messagesResourceBundle".equals(name)) {
            value = CubbyHttpServletRequestWrapper.getMessagesAsResourceBundle(this.getRequest(), this.getMessagesBehaviour());
        } else if ("org.seasar.cubby.formWrapperFactory".equals(name)) {
            if (this.formWrapperFactory == null) {
                this.formWrapperFactory = new FormWrapperFactoryImpl();
            }
            value = this.formWrapperFactory;
        } else {
            Attribute attribute;
            BeanDesc beanDesc;
            Object action = super.getAttribute("action");
            value = action != null ? ((beanDesc = BeanDescFactory.getBeanDesc(action.getClass())).hasPropertyAttribute(name) ? ((attribute = beanDesc.getPropertyAttribute(name)).isReadable() ? attribute.getValue(action) : super.getAttribute(name)) : super.getAttribute(name)) : super.getAttribute(name);
        }
        return value;
    }

    public Enumeration getAttributeNames() {
        HashSet<String> attributeNames = new HashSet<String>();
        attributeNames.add("contextPath");
        attributeNames.add("action");
        attributeNames.add("messages");
        attributeNames.add("org.seasar.cubby.messagesResourceBundle");
        attributeNames.add("org.seasar.cubby.formWrapperFactory");
        Object action = super.getAttribute("action");
        if (action != null) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(action.getClass());
            for (Attribute attribute : beanDesc.findtPropertyAttributes()) {
                if (!attribute.isReadable()) continue;
                attributeNames.add(attribute.getName());
            }
        }
        Enumeration defaultAttributeNames = super.getAttributeNames();
        while (defaultAttributeNames.hasMoreElements()) {
            attributeNames.add((String)defaultAttributeNames.nextElement());
        }
        return new IteratorEnumeration(attributeNames.iterator());
    }

    public String getParameter(String name) {
        String[] parameters = this.getParameterValues(name);
        if (parameters == null) {
            return null;
        }
        return parameters[0];
    }

    public Enumeration getParameterNames() {
        return new IteratorEnumeration(this.getParameterMap().keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        Map parameterMap = this.getParameterMap();
        return (String[])parameterMap.get(name);
    }

    public Map getParameterMap() {
        Map<String, String[]> parameterMap = this.buildParameterMap((HttpServletRequest)this.getRequest(), this.uriParameters);
        return parameterMap;
    }

    private Map<String, String[]> buildParameterMap(HttpServletRequest request, Map<String, String[]> uriParameters) {
        List<String> values;
        String name;
        HashMap<String, List<String>> extendedParameterMap = new HashMap<String, List<String>>();
        Map originalParameterMap = request.getParameterMap();
        for (Map.Entry entry : originalParameterMap.entrySet()) {
            name = (String)entry.getKey();
            values = new ArrayList();
            for (String value : (String[])entry.getValue()) {
                values.add(value);
            }
            extendedParameterMap.put(name, values);
        }
        for (Map.Entry<Object, Object> entry : uriParameters.entrySet()) {
            name = (String)entry.getKey();
            if (extendedParameterMap.containsKey(name)) {
                values = (List)extendedParameterMap.get(name);
                for (String value : (String[])entry.getValue()) {
                    values.add(value);
                }
                continue;
            }
            values = new ArrayList();
            for (String value : (String[])entry.getValue()) {
                values.add(value);
            }
            extendedParameterMap.put(name, values);
        }
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        for (Map.Entry entry : extendedParameterMap.entrySet()) {
            parameterMap.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
        }
        return parameterMap;
    }

    private static ResourceBundle getMessagesAsResourceBundle(ServletRequest request, MessagesBehaviour messagesBehaviour) {
        ResourceBundle bundle = (ResourceBundle)request.getAttribute("org.seasar.cubby.messagesResourceBundle");
        if (bundle != null) {
            return bundle;
        }
        ResourceBundle newBundle = messagesBehaviour.getBundle(request.getLocale());
        request.setAttribute("org.seasar.cubby.messagesResourceBundle", (Object)newBundle);
        return newBundle;
    }

    private static Map<String, Object> getMessagesAsMap(ServletRequest request, MessagesBehaviour messagesBehaviour) {
        Map messages = (Map)request.getAttribute("messages");
        if (messages != null) {
            return messages;
        }
        ResourceBundle bundle = CubbyHttpServletRequestWrapper.getMessagesAsResourceBundle(request, messagesBehaviour);
        Map<String, Object> newMessages = messagesBehaviour.toMap(bundle);
        request.setAttribute("messages", newMessages);
        return newMessages;
    }

    private MessagesBehaviour getMessagesBehaviour() {
        if (this.messagesBehaviour == null) {
            this.messagesBehaviour = this.cubbyFilter.createMessagesBehaviour();
        }
        return this.messagesBehaviour;
    }
}

