/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.oval.validation;

import java.lang.reflect.Method;
import net.sf.oval.context.ClassContext;
import net.sf.oval.context.ConstructorParameterContext;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.MethodEntryContext;
import net.sf.oval.context.MethodExitContext;
import net.sf.oval.context.MethodParameterContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.localization.context.OValContextRenderer;
import org.seasar.cubby.plugins.oval.validation.OValValidationContext;
import org.seasar.cubby.util.Messages;

public class RequestLocaleOValContextRenderer
implements OValContextRenderer {
    public String render(OValContext ovalContext) {
        Method method;
        String fieldName;
        ClassContext ctx;
        if (ovalContext instanceof ClassContext) {
            ctx = (ClassContext)ovalContext;
            fieldName = ctx.getClazz().getSimpleName();
        } else if (ovalContext instanceof FieldContext) {
            ctx = (FieldContext)ovalContext;
            fieldName = ctx.getField().getName();
        } else if (ovalContext instanceof ConstructorParameterContext) {
            ctx = (ConstructorParameterContext)ovalContext;
            fieldName = ctx.getParameterName();
        } else if (ovalContext instanceof MethodParameterContext) {
            ctx = (MethodParameterContext)ovalContext;
            fieldName = ctx.getParameterName();
        } else if (ovalContext instanceof MethodEntryContext) {
            ctx = (MethodEntryContext)ovalContext;
            method = ctx.getMethod();
            fieldName = this.isGetter(method) ? this.toPropertyName(method) : method.getName();
        } else if (ovalContext instanceof MethodExitContext) {
            ctx = (MethodExitContext)ovalContext;
            method = ctx.getMethod();
            fieldName = this.isGetter(method) ? this.toPropertyName(method) : method.getName();
        } else if (ovalContext instanceof MethodReturnValueContext) {
            ctx = (MethodReturnValueContext)ovalContext;
            method = ctx.getMethod();
            fieldName = this.isGetter(method) ? this.toPropertyName(method) : method.getName();
        } else {
            return ovalContext.toString();
        }
        OValValidationContext context = OValValidationContext.get();
        String resourceKeyPrefix = context.getResourceKeyPrefix();
        String fieldNameKey = resourceKeyPrefix == null ? fieldName : resourceKeyPrefix + fieldName;
        String fieldNameMessage = Messages.getText((String)fieldNameKey, (Object[])new Object[0]);
        return fieldNameMessage;
    }

    protected boolean isGetter(Method method) {
        if (method.getReturnType().equals(Boolean.TYPE) ? !method.getName().startsWith("is") : !method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        return !method.getReturnType().equals(Void.TYPE);
    }

    protected String toPropertyName(Method method) {
        String methodName = method.getName();
        String str1 = method.getReturnType().equals(Boolean.TYPE) ? methodName.substring(2) : methodName.substring(3);
        String propertyName = Character.toUpperCase(str1.charAt(0)) + str1.substring(1);
        return propertyName;
    }
}

