/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.guice;

import com.google.inject.Injector;
import javax.servlet.ServletContext;
import org.seasar.cubby.plugin.AbstractPlugin;
import org.seasar.cubby.spi.BeanDescProvider;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.ConverterProvider;
import org.seasar.cubby.spi.PathResolverProvider;
import org.seasar.cubby.spi.Provider;
import org.seasar.cubby.spi.RequestParserProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuicePlugin
extends AbstractPlugin {
    public static final String MODULE_INIT_PARAM_NAME = "cubby.guice.module";
    private Injector injector;

    public GuicePlugin() {
        this.support(BeanDescProvider.class);
        this.support(ContainerProvider.class);
        this.support(RequestParserProvider.class);
        this.support(PathResolverProvider.class);
        this.support(ConverterProvider.class);
    }

    public void initialize(ServletContext servletContext) throws Exception {
        super.initialize(servletContext);
        this.injector = (Injector)servletContext.getAttribute(Injector.class.getName());
        if (this.injector == null) {
            throw new IllegalStateException(Injector.class.getName() + "is not confugured.");
        }
    }

    public void destroy() {
        this.injector = null;
        super.destroy();
    }

    public <S extends Provider> S getProvider(Class<S> service) {
        if (this.isSupport(service)) {
            return (S)((Provider)service.cast(this.injector.getInstance(service)));
        }
        return null;
    }

    public Injector getInjector() {
        return this.injector;
    }
}

