/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;

public class RangeValidator
implements ScalarFieldValidator {
    private final String messageKey;
    private final long min;
    private final long max;

    public RangeValidator(long min, long max) {
        this(min, max, "valid.range");
    }

    public RangeValidator(long min, long max, String messageKey) {
        this.min = min;
        this.max = max;
        this.messageKey = messageKey;
    }

    public void validate(ValidationContext context, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (StringUtils.isEmpty(str)) {
                return;
            }
            try {
                long longValue = Long.parseLong(str);
                if (longValue >= this.min && longValue <= this.max) {
                    return;
                }
            }
            catch (NumberFormatException e) {}
        } else if (value == null) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setKey(this.messageKey);
        messageInfo.setArguments(this.min, this.max);
        context.addMessageInfo(messageInfo);
    }
}

