/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.seasar.cubby.controller.ThreadContext;
import org.seasar.cubby.tags.DynamicAttributesTagSupport;
import org.seasar.cubby.tags.TagUtils;
import org.seasar.cubby.util.TokenHelper;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.StringUtil;

public class TokenTag
extends DynamicAttributesTagSupport {
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public void doTag() throws JspException, IOException {
        PageContext context = (PageContext)this.getJspContext();
        JspWriter out = context.getOut();
        String token = TokenHelper.generateGUID();
        out.append((CharSequence)"<input type=\"hidden\" name=\"");
        if (StringUtil.isEmpty((String)this.name)) {
            out.append((CharSequence)"cubby.token");
        } else {
            out.append((CharSequence)this.name);
        }
        out.append((CharSequence)"\" value=\"");
        out.append((CharSequence)token);
        out.append((CharSequence)"\" ");
        out.write(TagUtils.toAttr(this.getDynamicAttribute()));
        out.append((CharSequence)"/>");
        HttpServletRequest request = ThreadContext.getRequest();
        if (request == null) {
            throw new IllegalStateException(MessageFormatter.getMessage((String)"ECUB0401", null));
        }
        HttpSession session = request.getSession();
        TokenHelper.setToken(session, token);
    }
}

