/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.Validation;
import org.seasar.cubby.validator.ValidationFailBehaviour;
import org.seasar.cubby.validator.ValidationRules;
import org.seasar.cubby.validator.ValidationUtils;

class ErrorPageValidationFailBehaviour
implements ValidationFailBehaviour,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String errorMessage;
    private final String[] fieldNames;

    public ErrorPageValidationFailBehaviour() {
        this(null, new String[0]);
    }

    public ErrorPageValidationFailBehaviour(String errorMessage, String ... fieldNames) {
        this.errorMessage = errorMessage;
        this.fieldNames = fieldNames;
    }

    public ActionResult getActionResult(Action action, Method method) {
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            action.getErrors().add(this.errorMessage, this.fieldNames);
        }
        Validation validation = ValidationUtils.getValidation(method);
        String errorPage = validation.errorPage();
        ValidationRules validationRules = ValidationUtils.getValidationRules(action, validation.rules());
        return validationRules.fail(errorPage);
    }
}

