/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.seasar.cubby.controller.FormWrapper;
import org.seasar.cubby.controller.FormWrapperFactory;
import org.seasar.cubby.tags.LinkSupport;
import org.seasar.cubby.tags.ParamParent;
import org.seasar.cubby.tags.TagUtils;
import org.seasar.cubby.util.LinkBuilder;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTag
extends BodyTagSupport
implements DynamicAttributes,
ParamParent {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> attrs = new HashMap<String, Object>();
    private Object value;
    private boolean encodeURL = true;
    private final LinkSupport linkSupport = new LinkSupport();
    private final LinkBuilder linkBuilder = new LinkBuilder();
    private FormWrapper formWrapper;

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.attrs.put(localName, value);
    }

    protected Map<String, Object> getDynamicAttribute() {
        return this.attrs;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setActionClass(String actionClass) {
        this.linkSupport.setActionClassName(actionClass);
    }

    public void setActionMethod(String actionMethod) {
        this.linkSupport.setActionMethodName(actionMethod);
    }

    public void setEncodeURL(boolean encodeURL) {
        this.encodeURL = encodeURL;
    }

    public void setProtocol(String protocol) {
        this.linkBuilder.setProtocol(protocol);
    }

    public void setPort(int port) {
        this.linkBuilder.setPort(port);
    }

    @Override
    public void addParameter(String name, String value) {
        this.linkSupport.addParameter(name, value);
    }

    public int doStartTag() throws JspException {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        FormWrapperFactory formWrapperFactory = (FormWrapperFactory)container.getComponent(FormWrapperFactory.class);
        this.formWrapper = formWrapperFactory.create(this.value);
        return 2;
    }

    public int doEndTag() throws JspException {
        String contextPath = (String)this.pageContext.getAttribute("contextPath", 2);
        if (this.linkSupport.isLinkable()) {
            String characterEncoding = this.pageContext.getRequest().getCharacterEncoding();
            String url = contextPath + this.linkSupport.getPath(characterEncoding);
            this.attrs.put("action", url);
        }
        if (this.encodeURL && this.attrs.containsKey("action")) {
            String url;
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            String actionPath = (String)this.attrs.get("action");
            try {
                url = this.linkBuilder.file(actionPath).toLink(request);
            }
            catch (MalformedURLException e) {
                throw new JspException((Throwable)e);
            }
            String encodedUrl = response.encodeURL(url);
            this.attrs.put("action", encodedUrl);
        }
        JspWriter out = this.pageContext.getOut();
        try {
            out.write("<form ");
            out.write(TagUtils.toAttr(this.getDynamicAttribute()));
            out.write(">");
            BodyContent bodyContent = this.getBodyContent();
            if (bodyContent != null) {
                bodyContent.writeOut((Writer)out);
            }
            out.write("</form>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        this.reset();
        return 6;
    }

    private void reset() {
        this.linkSupport.clear();
        this.linkBuilder.clear();
        this.attrs.clear();
        this.value = null;
        this.formWrapper = null;
    }

    public String[] getValues(String name) {
        return this.formWrapper.getValues(name);
    }
}

