/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.converter.impl;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.seasar.cubby.controller.ClassDetector;
import org.seasar.cubby.controller.DetectClassProcessor;
import org.seasar.cubby.converter.Converter;
import org.seasar.cubby.converter.ConverterFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterFactoryImpl
implements ConverterFactory,
DetectClassProcessor,
Disposable {
    private boolean initialized;
    private S2Container container;
    private NamingConvention namingConvention;
    private ClassDetector classDetector;
    private Set<Converter> converters = new LinkedHashSet<Converter>();
    private Map<String, Converter> converterCache = new HashMap<String, Converter>();

    public void setContainer(S2Container container) {
        this.container = container.getRoot();
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public void setClassDetector(ClassDetector classDetector) {
        this.classDetector = classDetector;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.classDetector.detect();
        for (Converter converter : (Converter[])Converter[].class.cast(this.container.findAllComponents(Converter.class))) {
            this.converters.add(converter);
        }
        DisposableUtil.add((Disposable)this);
        this.initialized = true;
    }

    public void dispose() {
        this.converters.clear();
        this.converterCache.clear();
        this.initialized = false;
    }

    @Override
    public Converter getConverter(Class<?> parameterType, Class<?> objectType) {
        this.initialize();
        Class destType = ClassUtil.getWrapperClassIfPrimitive(objectType);
        String cacheKey = ConverterFactoryImpl.cacheKey(parameterType, destType);
        Converter converter = this.converterCache.get(cacheKey);
        if (converter != null) {
            return converter;
        }
        return this.detectConverter(parameterType, destType);
    }

    private Converter detectConverter(Class<?> parameterType, Class<?> objectType) {
        Converter converter = this.getDistanceTable(parameterType, objectType);
        String cacheKey = ConverterFactoryImpl.cacheKey(parameterType, objectType);
        this.converterCache.put(cacheKey, converter);
        return converter;
    }

    private static String cacheKey(Class<?> parameterType, Class<?> objectType) {
        if (parameterType == null) {
            return objectType.getName();
        }
        return parameterType.getName() + objectType.getName();
    }

    private Converter getDistanceTable(Class<?> parameterType, Class<?> objectType) {
        TreeMap<Integer, Converter> distanceTable = new TreeMap<Integer, Converter>();
        for (Converter converter : this.converters) {
            if (!converter.canConvert(parameterType, objectType)) continue;
            int distance = this.getDistance(converter.getObjectType(), objectType);
            distanceTable.put(distance, converter);
        }
        if (distanceTable.isEmpty()) {
            return null;
        }
        return (Converter)distanceTable.values().iterator().next();
    }

    private int getDistance(Class<?> assigner, Class<?> assignee) {
        return this.getDistance(assigner, assignee, 0);
    }

    private int getDistance(Class<?> assigner, Class<?> assignee, int distance) {
        if (assignee.equals(assigner)) {
            return distance;
        }
        if (Enum.class.equals(assigner) && assignee.isEnum()) {
            return distance + 5;
        }
        if (this.isImplements(assigner, assignee)) {
            return distance + 5;
        }
        Class<?> superClass = assigner.getSuperclass();
        if (superClass == null) {
            return distance + 10;
        }
        return this.getDistance(superClass, assignee, distance + 10);
    }

    private boolean isImplements(Class<?> assigner, Class<?> assignee) {
        return !assigner.isInterface() && assignee.isInterface() && assignee.isAssignableFrom(assigner);
    }

    @Override
    public void processClass(String packageName, String shortClassName) {
        if (shortClassName.indexOf(36) != -1) {
            return;
        }
        String className = ClassUtil.concatName((String)packageName, (String)shortClassName);
        if (!this.namingConvention.isTargetClassName(className)) {
            return;
        }
        if (!className.endsWith(this.namingConvention.getConverterSuffix())) {
            return;
        }
        Class clazz = ClassUtil.forName((String)className);
        if (this.namingConvention.isSkipClass(clazz)) {
            return;
        }
        if ((clazz.getModifiers() & 0x400) != 0) {
            return;
        }
        if (!Converter.class.isAssignableFrom(clazz)) {
            return;
        }
        Converter converter = (Converter)Converter.class.cast(this.container.getComponent((Object)clazz));
        this.converters.add(converter);
    }
}

