/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.unit;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.Forward;
import org.seasar.cubby.action.Redirect;
import org.seasar.cubby.controller.ActionProcessor;
import org.seasar.cubby.controller.ActionResultWrapper;
import org.seasar.cubby.controller.ThreadContext;
import org.seasar.cubby.routing.InternalForwardInfo;
import org.seasar.cubby.routing.Router;
import org.seasar.framework.beans.util.Beans;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.unit.S2TigerTestCase;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CubbyTestCase
extends S2TigerTestCase {
    private Router router;
    private ActionProcessor actionProcessor;

    public static void assertPathEquals(Class<? extends ActionResult> resultClass, String expectedPath, ActionResult actualResult) {
        CubbyTestCase.assertPathEquals(resultClass, expectedPath, actualResult, "UTF-8");
    }

    public static void assertPathEquals(Class<? extends ActionResult> resultClass, String expectedPath, ActionResult actualResult, String characterEncoding) {
        CubbyTestCase.assertEquals((String)"ActionResult\u306e\u578b\u3092\u30c1\u30a7\u30c3\u30af", resultClass, actualResult.getClass());
        if (actualResult instanceof Forward) {
            CubbyTestCase.assertEquals((String)"\u30d1\u30b9\u306e\u30c1\u30a7\u30c3\u30af", (String)expectedPath, (String)((Forward)Forward.class.cast(actualResult)).getPath(characterEncoding));
        } else if (actualResult instanceof Redirect) {
            CubbyTestCase.assertEquals((String)"\u30d1\u30b9\u306e\u30c1\u30a7\u30c3\u30af", (String)expectedPath, (String)((Redirect)Redirect.class.cast(actualResult)).getPath(characterEncoding));
        }
    }

    protected ActionResult processAction(String originalPath) throws Exception {
        MockHttpServletRequest request = this.getRequest();
        CubbyTestCase.setServletPath(request, originalPath);
        MockHttpServletResponse response = this.getResponse();
        this.routing(request, response);
        this.setupThreadContext();
        ActionResultWrapper actionResultWrapper = this.actionProcessor.process((HttpServletRequest)request, (HttpServletResponse)response);
        if (actionResultWrapper == null) {
            return null;
        }
        return actionResultWrapper.getActionResult();
    }

    protected String routing(MockHttpServletRequest request, MockHttpServletResponse response) {
        InternalForwardInfo internalForwardInfo = this.router.routing((HttpServletRequest)request, (HttpServletResponse)response);
        if (internalForwardInfo == null) {
            CubbyTestCase.fail((String)(request.getServletPath() + " could not mapping to action"));
        }
        String internalForwardPath = internalForwardInfo.getInternalForwardPath();
        MockHttpServletRequest internalForwardRequest = this.getServletContext().createRequest(internalForwardPath);
        request.setAttribute("org.seasar.cubby.routings", internalForwardInfo.getOnSubmitRoutings());
        request.setAttribute("javax.servlet.forward.request_uri", (Object)request.getRequestURI());
        request.setAttribute("javax.servlet.forward.context_path", (Object)request.getContextPath());
        request.setAttribute("javax.servlet.forward.servlet_path", (Object)request.getServletPath());
        request.setAttribute("javax.servlet.forward.path_info", (Object)request.getPathInfo());
        request.setAttribute("javax.servlet.forward.query_string", (Object)request.getQueryString());
        String servletPath = internalForwardRequest.getServletPath();
        CubbyTestCase.setServletPath(request, servletPath);
        request.setQueryString(internalForwardRequest.getQueryString());
        if (StringUtil.isNotBlank((String)internalForwardRequest.getQueryString())) {
            Map<String, List<String>> pathParameters = this.parseQueryString(internalForwardRequest.getQueryString());
            for (Map.Entry<String, List<String>> entry : pathParameters.entrySet()) {
                String name = entry.getKey();
                for (String value : entry.getValue()) {
                    request.addParameter(name, value);
                }
            }
        }
        return internalForwardPath;
    }

    private static void setServletPath(MockHttpServletRequest request, String servletPath) {
        Field servletPathField = ClassUtil.getDeclaredField(request.getClass(), (String)"servletPath");
        servletPathField.setAccessible(true);
        try {
            servletPathField.set(request, servletPath);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void setupThreadContext() {
        ThreadContext.setRequest((HttpServletRequest)this.getRequest());
    }

    private Map<String, List<String>> parseQueryString(String queryString) {
        String[] tokens;
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        for (String token : tokens = queryString.split("&")) {
            List<String> values;
            String[] param = token.split("=");
            String name = param[0];
            String value = param[1];
            if (params.containsKey(name)) {
                values = (List)params.get(name);
            } else {
                values = new ArrayList();
                params.put(name, values);
            }
            values.add(value);
        }
        return params;
    }

    @Deprecated
    protected String routing(String orginalPath) {
        MockHttpServletResponse response;
        MockHttpServletRequest originalRequest = this.getServletContext().createRequest(orginalPath);
        InternalForwardInfo internalForwardInfo = this.router.routing((HttpServletRequest)originalRequest, (HttpServletResponse)(response = this.getResponse()));
        if (internalForwardInfo == null) {
            CubbyTestCase.fail((String)(orginalPath + " could not mapping to action"));
        }
        String internalForwardPath = internalForwardInfo.getInternalForwardPath();
        MockHttpServletRequest internalForwardRequest = this.getServletContext().createRequest(internalForwardPath);
        MockHttpServletRequest request = this.getRequest();
        request.setAttribute("org.seasar.cubby.routings", internalForwardInfo.getOnSubmitRoutings());
        Beans.copy((Object)internalForwardRequest, (Object)request).execute();
        Field servletPathField = ClassUtil.getDeclaredField(request.getClass(), (String)"servletPath");
        servletPathField.setAccessible(true);
        try {
            servletPathField.set(request, internalForwardRequest.getServletPath());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        request.setQueryString(internalForwardRequest.getQueryString());
        if (StringUtil.isNotBlank((String)internalForwardRequest.getQueryString())) {
            request.getParameterMap().putAll(HttpUtils.parseQueryString((String)request.getQueryString()));
        }
        return internalForwardPath;
    }
}

