/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.converter.impl;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import org.seasar.cubby.converter.ConversionHelper;
import org.seasar.cubby.converter.impl.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTimeConverter
extends AbstractConverter {
    @Override
    public Class<?> getObjectType() {
        return Time.class;
    }

    @Override
    public Object convertToObject(Object value, Class<?> objectType, ConversionHelper helper) {
        if (value == null) {
            return null;
        }
        DateFormat dateFormat = helper.getFormatPattern().getTimeFormat();
        return this.toTime((String)value, dateFormat);
    }

    protected Time toTime(String date, DateFormat dateFormat) {
        if (date == null || date.length() == 0) {
            return null;
        }
        try {
            return new Time(dateFormat.parse(date).getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public String convertToString(Object value, ConversionHelper helper) {
        if (value == null) {
            return null;
        }
        DateFormat formatter = helper.getFormatPattern().getTimeFormat();
        return formatter.format((Time)value);
    }
}

