/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tomcat55.valves;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;

public class StaticReferenceCleanerValve
extends ValveBase {
    private static final String info = "org.seasar.cubby.tomcat55.valves.StaticReferenceCleanerValve/1.0";
    private static StringManager sm = StringManager.getManager((String)"org.seasar.cubby.tomcat55.valves");
    private String methods;
    private String maps;
    private List methodNames = Collections.EMPTY_LIST;
    private List mapNames = Collections.EMPTY_LIST;

    public String getInfo() {
        return info;
    }

    public String getMethods() {
        return this.methods;
    }

    public void setMethods(String methods) {
        this.methods = methods;
        this.methodNames = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(methods, ",");
        while (tokenizer.hasMoreTokens()) {
            this.methodNames.add(tokenizer.nextToken());
        }
    }

    public String getMaps() {
        return this.maps;
    }

    public void setMaps(String maps) {
        this.maps = maps;
        this.mapNames = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(maps, ",");
        while (tokenizer.hasMoreTokens()) {
            this.mapNames.add(tokenizer.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            this.clean();
        }
    }

    private void clean() {
        Class<?> clazz;
        String className;
        StringTokenizer tokenizer;
        Log log = this.getContainer().getLogger();
        Iterator i = this.methodNames.iterator();
        while (i.hasNext()) {
            tokenizer = new StringTokenizer((String)i.next(), "#");
            className = tokenizer.nextToken();
            String methodName = tokenizer.nextToken();
            try {
                clazz = Class.forName(className);
                Method method = clazz.getMethod(methodName, new Class[0]);
                method.invoke(null, null);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("staticReferenceCleanerValve.methodInvokeSucceed", (Object)method));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)sm.getString("staticReferenceCleanerValve.methodInvokeFailed", (Object)className, (Object)methodName), (Throwable)e);
            }
        }
        i = this.mapNames.iterator();
        while (i.hasNext()) {
            tokenizer = new StringTokenizer((String)i.next(), "#");
            className = tokenizer.nextToken();
            String mapFieldName = tokenizer.nextToken();
            try {
                clazz = Class.forName(className);
                Field field = clazz.getDeclaredField(mapFieldName);
                field.setAccessible(true);
                Map map = (Map)field.get(null);
                map.clear();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("staticReferenceCleanerValve.mapFieldClearSucceed", (Object)field));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)sm.getString("staticReferenceCleanerValve.mapFieldClearFailed", (Object)className, (Object)this.maps), (Throwable)e);
            }
        }
    }
}

